; HOTKEY find next channel with same driver V2.00    1988   Tony Tebby   QJUMP
;
; V0.01, pjw, 2025 Oct 03, fiddled to return some job's channel ID
;                          console channels only!


        section code

        xdef    hk_nxchn

        include 'dev8_keys_qdos_sms'
        include 'dev8_keys_sys'
        include 'dev8_keys_chn'
        include 'dev8_keys_err'

;+++
; This routine takes a given channel ID and looks for the next channel with
; the same driver..
;
; AND the same job ID. Depending on the number given in d4, it returns
; only on the d4'th channel ID found (if any)
; Note: This routine assumes job #0's channel #0 is a console, and also
; only returns console channel IDs.
;
;       d4 cr   channel number / undefined
;       a0 cr p channel ID / next channel ID
;       a4 c    ID of relevant job to scan
;       error returns 0 or err.fdnf
;---
hk_nxchn
reglist reg     d1-d3/d7/a1
        movem.l reglist,-(sp)
        move.w  sr,d7
        trap    #0
        move.l  a0,d3
        moveq   #sms.info,d0             ; get sysvar
        trap    #do.sms2

        move.w  d3,d2                    ; starting channel number
        swap    d3                       ; tag
        move.w  sys_chtp(a0),d1          ; highest number
        move.l  sys_chtb(a0),a0          ; channel base

        move.w  d2,d0                    ; initial channel
        lsl.w   #2,d0
        move.l  (a0,d0.w),d0             ; still open?
        blt.s   hnc_fdnf
        move.l  d0,a1
        cmp.w   chn_tag(a1),d3           ; correct tag?
        bne.s   hnc_fdnf

        move.l  chn_drvr(a1),d3          ; keep driver

hnc_next
        addq.w  #1,d2                    ; next channel
        cmp.w   d1,d2                    ; all checked?
        bgt.s   hnc_fdnf                 ; ... yes

        move.w  d2,d0
        lsl.w   #2,d0
        move.l  (a0,d0.w),d0             ; channel open?
        blt.s   hnc_next
        move.l  d0,a1

        cmpa.l  chn_ownr(a1),a4          ; correct job?
        bne.s   hnc_next

        cmp.l   chn_drvr(a1),d3          ; the right driver?
        bne.s   hnc_next                 ; ... no

        dbra    d4,hnc_next              ; final channel number?

        move.l  chn_tag(a1),d0
        move.w  d2,d0
        move.l  d0,a0                    ; next channel
        moveq   #0,d0

hnc_exit
        move.w  d7,sr
        movem.l (sp)+,reglist
        tst.l   d0
        rts

hnc_fdnf
        moveq   #err.fdnf,d0
        bra.s   hnc_exit

*
        end
