100 REMark $$asmb=win1_uti_caps_CAPS_bin,0,10
102 REMark $$stak=256
104 REMark $$heap=64
106 :
108 ext_proc 'BUTFREE'
110 ext_fn 'BUTUSE%', 'VALID%', 'DETAB$', 'RPT%'
112 :
114 rem + ************************************************************************ +
116 rem *<                                  Caps                                  >*
118 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
120 rem *                        Caps lock indicator button                        *
122 rem *                                                                          *
124 rem * Needs SMSQ/E or Qdos + TK2, and Qlib_run & ptrmen_cde                    *
126 rem + ------------------------------------------------------------------------ +
128 rem * V0.01, pjw, 2018 Jan 21                                                  *
130 rem * V0.02, pjw, 2018 Apr 23, Circular                                        *
132 rem * V0.03, pjw, 2021 Jan 21. Removed SV_BASE, repackaged.                    *
134 rem * V0.04, pjw, 2022 Jun 21, Extended SMSQ/E version                         *
136 rem + ************************************************************************ +
138 :
140 :
142 rem $$off
144  JOB_NAME 'Caps'
146 rem $$on
148 :
150 rv% = 33:                               rem Return vector
152 je% =  0:                               rem Job events (not used)
154 ud% = 25:                               rem Update frequency
156 xs% = 16:                               rem Button dimensions
158 ys% = 14
160 :
162 xp% = xs%: yp% = ys%:                   rem Reserve this much
164 ERT BUTUSE%(xp%, yp%):                  rem  space in Button Frame
166 :
168 quote$  = '"' & "'"
170 er = GetCmd(CMD$)
172 if er = 1 then
174  er = Extract(cb, cf, cs)
176 else
178  er = Default
180 endif
182 :
184 ch = FOPEN(#0; "con_"): ERT ch
186 WINDOW#ch; xs%, ys%, xp%, yp%
188 if col = 2: wm_paper#ch; cb: else: paper#ch; cb
190 SCALE#ch; xs%, 0, 0: FILL#ch; 1
192 if col = 2: wm_ink#ch; cf: else: ink#ch; cf
194 cls#ch
196 CIRCLE#ch; xs% / 2, xs% / 2, xs% / 2
198 :
200 SPJOB -1, 126
202 :
204 REPeat lp
206  ls = PEEK_W(!! $88)
208  IF ls THEN
210   if col = 2: wm_ink#ch; cs: else: ink#ch; cs
212   FILL#ch; 1: CIRCLE#ch; xs% / 2, xs% / 2, xs% / 3
214  ELSE
216   if col = 2: wm_ink#ch; cf: else: ink#ch; cf
218   FILL#ch; 1: CIRCLE#ch; xs% / 2, xs% / 2, xs% / 2
220  END IF
222  :
224  REPeat il
226   sw% = rpt%(#ch; rv%, je%, xp%, yp%, ud%): IF rv% div 256 = 27: QUIT
228   IF ls <> PEEK_W(!! $88) then
230    if noise then
232     if PEEK_W(!! $88): CapsOn: else: CapsOff
234    endif
236    EXIT il
238   endif
240  END REPeat il
242 END REPeat lp
244 :
246 :
248 def fn Extract
250 loc p%, v
252 p% = ':' instr cml$
254 if p% < 2 or p% = len(cml$): ret Default
256 cb$ = cml$(1 to p% - 1): cml$ = cml$(p% + 1 to len(cml$))
258 :
260 p% = ':' instr cml$
262 if p% < 2 or p% = len(cml$): ret Default
264 cf$ = cml$(1 to p% - 1): cml$ = cml$(p% + 1 to len(cml$))
266 :
268 sel on col
270  = 0:           rem QL
272    cb = ValidQL(cb$):   if cb = -1: ret Default
274    cf = ValidQL(cf$):   if cf = -1: ret Default
276    cs = ValidQL(cml$):  if cs = -1: ret Default
278  = 1:           rem RGB
280    cb = ValidRGB(cb$):  if cb = -1: ret Default
282    cf = ValidRGB(cf$):  if cf = -1: ret Default
284    cs = ValidRGB(cml$): if cs = -1: ret Default
286  = 2:           rem Wman palette
288    cb = ValidWM(cb$):   if cb = -1: ret Default
290    cf = ValidWM(cf$):   if cf = -1: ret Default
292    cs = ValidWM(cml$):  if cs = -1: ret Default
294 endsel
296 ret 0
298 enddef Extract
300 :
302 :
304 def fn Default
306 cb = 0: cf = 4: cs = 2: col = 0
308 ret 0
310 enddef Default
312 :
314 def fn ValidQL(v$)
316 if not valid%(3, v$): ret -1
318 v = v$
320 if v < 0 or v > 255: ret -1
322 ret v
324 enddef ValidQL
326 :
328 def fn ValidWM(v$)
330 if not valid%(3, v$): ret -1
332 v = v$
334 if v < 512 or v > 1024: ret -1
336 ret v
338 enddef ValidWM
340 :
342 def fn ValidRGB(v$)
344 if v$(1) = '$' then
346  if len(v$) > 7 or len(v$) < 2: ret -1
348 else
350  if len(v$) > 6 or len(v$) = 0: ret -1
352 endif
354 if ValidHex(v$, v): ret -1
356 ret v
358 enddef ValidRGB
360 :
362 :
364 rem + ------------------------------------------------------------------------ +
366 rem |<                                ValidHex                                >|
368 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
370 rem |       Validate a hex string and return its decimal value or error        |
372 rem |                                                                          |
374 rem | Returns hex value in r.hx parameter!                                     |
376 rem | A valid hex number is of the form                                        |
378 rem |    [$]<hex digit>[<hex digit>] * 7                                       |
380 rem | Where [] => optional, and hex digits are 0..9, A..F, a..f                |
382 rem | The first non-hex charcter in an otherwise valid number terminates the   |
384 rem | the number but does not invalidate it!                                   |
386 rem | Numbers with more than 8 hex digits are truncated, but not invalidated!  |
388 rem + ------------------------------------------------------------------------ +
390 rem | V0.04, pjw, 2019 Dec 16, rewrite                                         |
392 rem + ------------------------------------------------------------------------ +
394 :
396 DEFine FuNction ValidHex(hx$, r.hx)
398 LOCal i%, d%, e%
400 d% = (('$' INSTR hx$) = 1) + 1
402 IF LEN(hx$) < d%: RETurn -15
404 e% = d% + 7
406 IF e% > LEN(hx$): e% = LEN(hx$)
408 FOR i% = d% TO e%
410  IF NOT hx$(i%) INSTR '0123456789ABCDEF': e% = i% - 1: EXIT i%
412 END FOR i%
414 IF e% < d%: RETurn -15
416 r.hx = HEX(hx$(d% TO e%))
418 RETurn 0
420 END DEFine ValidHex
422 :
424 :
426 rem + ------------------------------------------------------------------------ +
428 rem |<                             Parse Command Line                         >|
430 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
432 rem |                    Parses command line and sets defaults                 |
434 rem |                                                                          |
436 rem |           /Q      - QL colours    b:f:s   0..255 each                    |
438 rem |           /R      - RGB colours   b:f:s   [$]0..FFFFFF each              |
440 rem |           /W      - Wman colours  b:f:s   512..1024 each                 |
442 rem |           /P      - Palette       0..3    (Wman only)                    |
444 rem |           /S      - Sound         0/1     off/on                         |
446 rem |                                                                          |
448 rem | GLOBal: quote$                                                           |
450 rem | Dependency: DETAB$                                                       |
452 rem + ------------------------------------------------------------------------ +
454 rem | V0.01, pjw, 2019 Jul 01, base version                                    |
456 rem | V0.01, pjw, 2022 Jun 21, Caps version                                    |
458 rem + ------------------------------------------------------------------------ +
460 :
462 def fn GetCmd(cl$)
464 loc p%, t$(30)
466 :
468 noise = 0
470 pal   = 0
472 if len(cl$) = 0: ret Default
474 :
476 t$ = Getent$("S"): if valid%(3, t$): noise = t$
478 t$ = Getent$("P"): if valid%(3, t$): pal = t$
480 sel on pal: = 0 to 3:: = remainder: pal = 0
482 :
484 cml$ = Getent$("Q"): if len(cml$): col = 0: ret 1
486 cml$ = Getent$("R"): if len(cml$): col = 1: colour_24: ret 1
488 cml$ = Getent$("W"): if len(cml$): col = 2: else: ret Default
490 sp_jobpal -1, pal
492 :
494 ret 1
496 enddef GetCmd
498 :
500 def fn Getent$(c$)
502 rem Caller's cl$, p%, t$
504 rem Given the character get the entry
506 rem /C [<spaces>] ["|'] <entry> ["|'] <space> | <space> /C+1 | <eol>
508 :
510 p% = '/' & c$ instr cl$
512 if p% = 0: ret ''
514 t$ = detab$(cl$(p% + 2 to len(cl$)))
516 p% = ' /' instr t$
518 if p% > 0: t$ = t$(1 to p%): else: p% = len(t$)
520 for p% = len(t$) to 1 step -1
522  if not t$(p%) instr ' /': exit p%
524 endfor p%
526 :
528 t$ = t$(1 to p%)
530 if len(t$) > 1 then
532  p% = t$(1) instr quote$
534  if p% then
536   if (t$(len(t$)) instr quote$) = p% then
538    t$ = t$(2 to len(t$) - 1)
540   endif: endif: endif
542 ret t$
544 enddef Getent$
546 :
548 :
550 def proc CapsOn: beep 2000, 50: pause#ch; 10: beep 2000, 20: enddef CapsOn
552 def proc CapsOff: beep 2000, 20: pause#ch; 10: beep 2000, 50: enddef CapsOff
