* S*Basic function IOBSMUL
*
* P Witte
* V0.03        Not stress tested yet!
* V0.04, pjw, June 4th 2019, new library (safer bp.let)
* V0.05 Removed unnecessary "relativisation" of stack pointer

        section code

        include dev8_keys_sbasic
        include dev8_keys_qdos_io

        xdef IOBSMUL,IOBSUML

        xref getpars,channel
        xref sputp_a1,io_ret,io_rtint

*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Send string:
*
*       er% = IOBSMUL%( [#ch%;] timeout%, str$)  : rem Send bytes
*       er% = IOBSUML%( [#ch%;] timeout%, str$)  : rem Send Untranslated bytes
*
*       where:  #ch% is the channel number to use (default #3)
*
*               timeout% [-1,0..32k] allow this many frames to complete
*
*               str$ contains the string to send to the channel.
*                   Any residual bytes in string$ that could not be
*                   transmitted before timeout, or due to error, are
*                   retained in string$, and may be used for a later retry
*
*               er% error code: NC, ICHN, DVFL
*
IOBSMUL
        moveq #iob.smul,d4      Send MULtiple bytes
        bra.s start

IOBSUML
        moveq #iob.suml,d4      Send Untranslated MuLtiple bytes

start
        bsr channel             get channel (default #3)
        bne.s err_ret           hard error return

        moveq #$10,d0           get timeout as int
        bsr getpars
        bne.s err_ret           hard error

        move.w 0(a6,a1.l),d6    timeout
        move.l a3,d5            d5.l = saved string par pointer
        addq.l #2,sb_arthp(a6)  reset stack

        move.l sb_arthp(a6),d7  d7.l "empty" stack pointer
;        sub.l sb_arthb(a6),d7   make it relative to BAS

        moveq #$14,d0           get 1 string
        bsr getpars
        bne.s err_ret

        move.w 0(a6,a1.l),d2    d2.w = len = number of bytes to send
        move.w d6,d3            d3 = timeout
        addq.l #2,a1            a1 -> first char

        move.l d4,d0            send multiple (possibly untranslated) bytes
        trap #do.relio          a6 rel
        trap #do.io             => d1 = number of bytes sent

        move.l d0,d6            d6 = trap's error return code

        movea.l a1,a2           a1, a2 -> last byte sent
        move.w d2,d4            d4.w = number of bytes to send
        sub.w d1,d2             d2.w = number of remaining bytes
        adda.w d2,a1            a1 -> stack base

        btst #0,d4              odd number of bytes sent?
        beq.s ss_1               no,
        addq.l #1,a1             yes, make even

ss_1
        tst.w d1                if no bytes sent we're done
        beq io_ret               just return the same string


*  as for the remaining bytes..
ss_more
        move.l d5,a3            point to string parameter
        move.w d2,d4            d4.w = len (ie bytes to send - bytes sent)
        btst #0,d1              if number of bytes sent is even..
        beq.s ss_even            no problem!
        btst #0,d2              otherwise: if remaining str len even
        beq.s ss_mbule           shuffle 1 byte up
        movea.l a2,a5

*  else shuffle 1 byte down
ss_mbd
        move.b 0(a6,a5.l),-1(a6,a5.l)
        addq.l #1,a5
        cmpa.l a5,a1            are we at the end?
        bpl.s ss_mbd            if not loop
        lea.l -1(a2),a1         a1 -> start of string
        bra.s ss_ret            d4 = len, return

err_ret
        rts

*
ss_mbul
        subq.l #1,a1
        move.b -1(a6,a1.l),0(a6,a1.l)

ss_mbule
        dbra d2,ss_mbul
        bra.s ss_ret

*
ss_even
        movea.l a2,a1

*
ss_ret
        subq.l #2,a1            make room for len
        move.w d4,0(a6,a1.l)    put new len in place
        bsr sputp_a1
        bra io_rtint
        nop

*
        end
