100 rem + ************************************************************************ +
102 rem *<                Re-create (LIST) an S*BASIC source file,                >*
104 rem *                    working from the QSAVEd (sav) file                    *
106 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
108 rem * NB QDOS: Replace dots in all variable names with underscore!             *
110 rem * Apart from that, should be compatible with all systems with latest TK2   *
112 rem *                                                                          *
114 rem *    EX <path>LIST_bas;"<path>filename_sav"                (SMSQ/E)        *
116 rem * or                                                                       *
118 rem *    EX <path>LIST_bas   (Manual input of filename)        (SMSQ/E)        *
120 rem * or                                                                       *
122 rem *    LRUN <path>LIST_bas (Manual input of filename)        (All OS)        *
124 rem + ------------------------------------------------------------------------ +
126 rem * V0.01, PWitte 1991                                                      *
128 rem * V0.02, pjw, 28th Mar 2001, Removed references to INTEGER$, LONG$, FLOAT, *
130 rem *                            ALTSTR% and REMOVE$. Only FSTRG$ remains      *
132 rem * V0.03, pjw, Jan 04 2010                                                  *
134 rem * V0.04, pjw, Nov 03 2018, bugfixes - but some problem! Dont use!!!        *
136 rem * V0.05, pjw, 2025 Sep 20, replaced FSTRG$ with IOBFMUL%: Works!           *
138 rem * V0.06, pjw, 2025 Sep 20, Removed last external toolkit reference!        *
140 rem * V0.07, pjw, 2025 Sep 22, New integer tokens $89 and $8A, catered for     *
142 rem * V0.08, pjw, 2025 Sep 22, Fixed bug: wrong byte returned in MinB%         *
144 rem + ************************************************************************ +
146 :
148 :
150 if jobid then
152  cd = fopen(#0; "con_"):                rem Report channel
154  fnmsav$ = CMD$
156  if len(fnmsav$) < 5 then
158   fnmsav$ = ''
160  else
162   if not 'sav' == fnmsav$(len(fnmsav$) - 2 to len(fnmsav$)) then
164    fnmsav$ = ''
166   endif
168  endif
170 endif
172 :
174 cls#cd
176 if fnmsav$ = '' then
178  input#cd; 'File to process'! fnmsav$
180 else
182  print#cd; 'Filename "'; fnmsav$; '"'
184 endif
186 :
188 if len(fnmsav$) < 5 then
190  print#cd; 'Aborted'
192 else
194  ch = fop_over('ram1_test_bas'): ert ch: rem Output file
196  :
198  Init_Constants
200  er = Load_File(fnmsav$)
202  if er < 0 then
204   print#cd; 'Error loading "'; fnmsav$; '"'! er
206  else
208   errs = 0
210   ListProg#ch
212   print#cd; 'Errors:'! errs
214   close#ch
216  endif
218 endif
220 if jobid: pause: quit
222 :
224 :
226 rem + ------------------------------------------------------------------------ +
228 rem |<                               Load_File                                >|
230 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
232 rem |                    Check flag and get header details                     |
234 rem |                                                                          |
236 rem | Set up data structures (arrays)                                          |
238 rem | Copy name list into new table                                            |
240 rem | Lbytes rest of file in a heap                                            |
242 rem |                                                                          |
244 rem | GLObal ncount%, ntsize, pfsize, lcount%                                  |
246 rem + ------------------------------------------------------------------------ +
248 rem | V0.01, pjw, 1991                                                         |
250 rem + ------------------------------------------------------------------------ +
252 :
254 define function Load_File(fnm$)
256 loc i%, cs, m%, nts%, fl, n$
258 cs = fop_in(fnm$): if cs < 0: ret cs
260 fl = flen(#cs)
262 get#cs; m%: rem Get magic
264 if m% <> $5131: ret -19: rem $5131 = 'Q1' Wrong version?
266 get#cs; m%: rem Get version(?)
268 if m% <> $380: print#cd;'Version ='! hex$(m%,16)
270 get#cs; ncount%: rem Get number of names
272 get#cs; nts%   : rem Get size of name table. (Unsigned?)
274 get#cs; lcount%: rem Get number of lines
276 if nts% < 0: ntsize = 65536 + nts%: else: ntsize = nts%
278 dim Names$(ncount%, 20), Types%(ncount%), Deflin%(ncount%)
280 for i% = 0 to ncount% - 1
282  if eof(#cs): ret -10: rem Error EF
284  get#cs; Types%(i%), Deflin%(i%)
286  get#cs; n$: Names$(i%) = n$: m% = len(n$)
288  if m% <> (m% && -2): bget#cs; m%: rem Compensate for odd byte
290 endfor i%
292 pfsize = fl - fpos(#cs): if pfsize < 8: ret -10
294 base = alchp(pfsize): if base = 0: base = -3
296 if base < 0: ret base
298 fl = LoadF
300 close#cs
302 ret fl
304 enddef Load_File
306 :
308 :
310 rem + ------------------------------------------------------------------------ +
312 rem |<                                 LoadF                                  >|
314 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
316 rem |                          Subroutine of Load_File                         |
318 rem |                                                                          |
320 rem | Loads remainder of file into memory                                      |
322 rem |                                                                          |
324 rem | Reads GLOBal pfsize, base                                                |
326 rem + ------------------------------------------------------------------------ +
328 rem | V0.01, 1991                                                              |
330 rem | V0.02, 2001, FSTR$                                                       |
332 rem | V0.03, pjw, 2025 Sep 20, Replaced FSTRG$ and IOBFMUL% with BGET          |
334 rem + ------------------------------------------------------------------------ +
336 :
338 define function LoadF
340 loc flp, b, remain, end%, str$(128)
342 end% = dimn(str$): str$(0) = end%
344 b = base: remain = pfsize
346 :
348 rep flp
350  if remain < end%: end% = remain
352  bget#cs; str$(1 to end%): rem Read up to 128 bytes at a time
354  poke$ b, str$(1 to end%): b = b + end%
356  remain = remain - end%: if remain <= 0: exit flp
358 endrep flp
360 ret 0
362 enddef LoadF
364 :
366 :
368 rem + ------------------------------------------------------------------------ +
370 rem |<                                ListProg                                >|
372 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
374 rem |                       This does all the hard work                        |
376 rem |                                                                          |
378 rem + ------------------------------------------------------------------------ +
380 rem | V0.01, pjw, 1991                                                         |
382 rem + ------------------------------------------------------------------------ +
384 :
386 define procedure ListProg(cw)
388 loc scan, c%, pos, tb%, tw%, sz
390 sz = base + pfsize: pos = base + 2: rem Get start of program
392 rep scan
394  IF pos > sz: EXIT scan
396 :
398  tb% = PEEK(pos)
400  sel on tb%
402   = tkb.space :rem spaces in the listing - two bytes: token count
404     c% = PEEK(pos + 1)
406     print#cw; fill$(' ', c%);
408   = tkb.keyw     : rem all sorts of keywords:
410     tw% = PEEK(pos + 1)
412     sel on tw%
414      = tkw.end   : print#cw; 'END';
416      = tkw.for   : print#cw; 'FOR';
418      = tkw.if    : print#cw; 'IF';
420      = tkw.rep   : print#cw; 'REPeat';
422      = tkw.sel   : print#cw; 'SELect';
424      = tkw.when  : print#cw; 'WHEN';
426      = tkw.def   : print#cw; 'DEFine';
428      = tkw.proc  : print#cw; 'PROCedure';
430      = tkw.fn    : print#cw; 'FuNction';
432      = tkw.go    : print#cw; 'GO';
434      = tkw.to    : print#cw; 'TO';
436      = tkw.sub   : print#cw; 'SUB';
438      = tkw.err   : print#cw; 'ERRor';
440      = tkw.rest  : print#cw; 'RESTORE';
442      = tkw.next  : print#cw; 'NEXT';
444      = tkw.exit  : print#cw; 'EXIT';
446      = tkw.else  : print#cw; 'ELSE';
448      = tkw.on    : print#cw; 'ON';
450      = tkw.ret   : print#cw; 'RETurn';
452      = tkw.rmdr  : print#cw; 'REMAINDER';
454      = tkw.data  : print#cw; 'DATA';
456      = tkw.dim   : print#cw; 'DIM';
458      = tkw.loc   : print#cw; 'LOCal';
460      = tkw.let   : print#cw; 'LET';
462      = tkw.then  : print#cw; 'THEN';
464      = tkw.step  : print#cw; 'STEP';
466      = tkw.rem   : print#cw; 'REMark';
468      = tkw.mist  : print#cw; 'MISTake';
470      = remainder : print#cw; 'Unknown!';: errs = 1
472     endsel
474     if peek_w(pos + 2) <> tkweol and peek_w(pos + 2) <> tkwspace: PRINT#cw; ' ';
476 :
478   = tkb.odds     : rem all sorts of separators:
480     tw% = PEEK(pos + 1)
482     sel on tw%
484      = tkw.lequ  : print#cw; '='; :rem (LET) =
486      = tkw.coln  : print#cw; ':';
488      = tkw.hash  : print#cw; '#';
490      = tkw.comma : print#cw; ',';
492      = tkw.lpar  : print#cw; '(';
494      = tkw.rpar  : print#cw; ')';
496      = tkw.lbrc  : print#cw; '{';
498      = tkw.rbrc  : print#cw; '}';
500      = tkw.space : print#cw; ' ';: rem space (significant)
502      = tkw.eol   : print#cw;     : rem end of line
504        pos = pos + 2: rem Skip line length
506        rem pause
508      = remainder : print#cw; '!';:     errs = 2
510     endsel
512 :
514   = tkb.oper     : rem all sorts of operators:
516     tw% = PEEK(pos + 1)
518     sel on tw%
520      = tkw.plus  : print#cw; '+';
522      = tkw.minus : print#cw; '-';
524      = tkw.mulf  : print#cw; '*';
526      = tkw.divf  : print#cw; '/';
528      = tkw.ge    : print#cw; '>=';
530      = tkw.gt    : print#cw; '>';
532      = tkw.apeq  : print#cw; '==';
534      = tkw.eq    : print#cw; '=';
536      = tkw.ne    : print#cw; '<>';
538      = tkw.le    : print#cw; '<=';
540      = tkw.lt    : print#cw; '<';
542      = tkw.bor   : print#cw; '||';
544      = tkw.band  : print#cw; '&&';
546      = tkw.bxor  : print#cw; '^^';
548      = tkw.power : print#cw; '^';
550      = tkw.cnct  : print#cw; '&';
552      = tkw.or    : print#cw; 'OR';
554      = tkw.and   : print#cw; 'AND';
556      = tkw.xor   : print#cw; 'XOR';
558      = tkw.mod   : print#cw; 'MOD';
560      = tkw.div   : print#cw; 'DIV';
562      = tkw.instr : print#cw; 'INSTR';
564      = remainder : print#cw; '?!';:    errs = 3
566     endsel
568
570   = tkb.mon  : rem Monadic
572     tw% = PEEK(pos + 1)
574     sel on tw%
576      = tkw.neg   : print#cw; '-'; :rem negate
578      = tkw.pos   : print#cw; '+'; :rem positivel!
580      = tkw.bnot  : print#cw; '~~';
582      = tkw.not   : print#cw; 'NOT';
584      = 0         : print#cw; '?'; :rem No qualifyer?
586      = remainder : print#cw; ,tw%, :   errs = 4
588     endsel
590
592 :
594   = tkb.seps  : rem all sorts of formatting separators:
596     tw% = PEEK(pos + 1)
598     sel on tw%
600      = tkw.scoma : print#cw; ','; :rem separator comma
602      = tkw.scoln : print#cw; ';'; :rem semicolon
604      = tkw.bslsh : print#cw; '\'; :rem backslash
606      = tkw.excl  : print#cw; '!'; :rem exclamation mark
608      = tkw.sto   : print#cw; 'TO'; :rem separator TO
610      = remainder : print#cw; '?'; :    errs = 5
612     endsel
614
616 :
618   = tkb.qstr  : rem delimited strings
620     tw% = PEEK(pos + 1)
622     sel on tw%
624      = tkw.quote : rem string delimited by "quotes"
626        print#cw; ;'"'; GetText$; '"';
628      = tkw.apost : rem string delimited by 'apostrophes'
630        print#cw; "'"; GetText$; "'";
632      = remainder: print#cw; 'What is this?'; : errs = 6
634     endsel
636
638 :
640   = tkb.text  : rem text (after REMark)
642     print#cw; GetText$;
644
646   = tkb.lno   : rem line number (word)
648     pos = pos + 2: lnum% = peek_w(pos)
650     print#cw; lnum%; ' ';
652
654   = tkb.name  : rem name
656     pos = pos + 2
658     print#cw; GetName$;
660
662   = $89:                rem Integer literals (undocumented)
664     print#cw; MintB%;
666
668   = $8A:                rem Integer literals (undocumented)
670     print#cw; MintW%;
672
674   = $d0 to $df: rem %
676     print#cw; GetInt$;
678
680   = $e0 to $ef: rem $
682     print#cw; GetHex$;
684
686   = $f0 to $ff: rem Start of literal float
688     print#cw; GetFloat;
690
692   = remainder
694     if lnum% <> 0 then
696      errs = 9
698      print#cd; '"'; lnum%! hex$(tb%,8); "'"; "???": rem Some error
700     endif
702  endsel
704  pos = pos + 2
706 endrep scan
708 enddef ListProg
710 :
712 :
714 rem + ######################################################################## +
716 rem #<                              Subroutines                               >#
718 rem + ######################################################################## +
720 :
722 def fn MintB%
724 loc x%
726 x% = peek(pos + 1):         rem Oops!
728 if x% >= 128: ret x% - 256
730 ret x%
732 enddef MintB%
734 :
736 def fn MintW%
738 pos = pos + 2
740 ret peek_w(pos)
742 enddef MintW%
744 :
746 define function GetName$
748 ret Names$(peek_w(pos))
750 enddef GetName$
752 :
754 define function GetFloat
756 loc x%, m
758 x% = peek_w(pos) && $0fff
760 m = peek_l(pos + 2)
762 pos = pos + 4
764 if x% = 0 or m = 0: ret 0
766 ret m * 2 ^ (x% - $81f)
768 enddef GetFloat
770 :
772 define function Denul$(t$)
774 loc i%, n%
776 n% = 0
778 for i% = 1 to len(t$)
780  if t$(i%) <> '0': n% = i%: exit i%
782 endfor i%
784 if n% = 0: ret '0'
786 ret remv$(0,  n% - 1, t$)
788 enddef Denul$
790 :
792 define function GetInt$
794 ret '%' & Denul$(bin$(GetFloat, 32))
796 enddef GetInt$
798 :
800 define function GetHex$
802 ret '$' & Denul$(hex$(GetFloat, 32))
804 enddef GetHex$
806 :
808 define function GetText$
810 loc l%, t$
812 pos = pos + 2
814 l% = peek_w(pos): rem Length of text
816 t$ = peek$(pos + 2, l%)
818 pos = pos + ((l% + 1 ) && -2)
820 ret t$
822 enddef GetText$
824 :
826 DEFine FuNction REMV$(from%, too%, str$)
828 REMark V0.02
830 :
832 IF from% < 2 THEN
834  IF too% >= LEN(str$): RETurn ''
836  RETurn str$(too% + 1 TO LEN(str$))
838 END IF
840 IF too% >= LEN(str$) THEN
842  RETurn str$(1 TO from% - 1)
844 ELSE
846  RETurn str$(1 TO from% - 1) & str$(too% + 1 TO LEN(str$))
848 END IF
850 END DEFine REMV$
852 :
854 :
856 define procedure Init_Constants
858 bv_pfbas     = $10   : rem Start of program file
860 bv_pfp       = $14   : rem Pointer to top of program area
862 bv_ntbas     = $18   : rem Name Table (NT)
864 bv_nlbas     = $20   : rem Name list
866
868 tkb.space    = $80   : rem spaces in the listing - two bytes: token count
870
872 tkb.keyw     = $81   : rem all sorts of keywords:
874 tkw.end      = $01   : rem END
876 tkw.for      = $02   : rem FOR
878 tkw.if       = $03   : rem IF
880 tkw.rep      = $04   : rem REPeat
882 tkw.sel      = $05   : rem SELect
884 tkw.when     = $06   : rem WHEN
886 tkw.def      = $07   : rem DEFine
888 tkw.proc     = $08   : rem PROCedure
890 tkw.fn       = $09   : rem FuNction
892 tkw.go       = $0a   : rem GO
894 tkw.to       = $0b   : rem TO
896 tkw.sub      = $0c   : rem SUB
898 tkw.err      = $0e   : rem ERRor
900 tkw.rest     = $11   : rem RESTORE
902 tkw.next     = $12   : rem NEXT
904 tkw.exit     = $13   : rem EXIT
906 tkw.else     = $14   : rem ELSE
908 tkw.on       = $15   : rem ON
910 tkw.ret      = $16   : rem RETurn
912 tkw.rmdr     = $17   : rem REMAINDER
914 tkw.data     = $18   : rem DATA
916 tkw.dim      = $19   : rem DIM
918 tkw.loc      = $1a   : rem LOCal
920 tkw.let      = $1b   : rem LET
922 tkw.then     = $1c   : rem THEN
924 tkw.step     = $1d   : rem STEP
926 tkw.rem      = $1e   : rem REMark
928 tkw.mist     = $1f   : rem MISTake
930
932 tkb.odds     = $84   : rem all sorts of separators:
934 tkw.lequ     = $01   : rem (LET) =
936 tkw.coln     = $02   : rem :
938 tkw.hash     = $03   : rem #
940 tkw.comma    = $04   : rem ,
942 tkw.lpar     = $05   : rem )
944 tkw.rpar     = $06   : rem (
946 tkw.lbrc     = $07   : rem {
948 tkw.rbrc     = $08   : rem }
950 tkw.space    = $09   : rem space (significant)
952 tkw.eol      = $0a   : rem end of line
954
956 tkwspace     = $8409 - 65536 : rem cope with unsigned
958 tkweol       = $840a - 65536
960
962 tkb.oper     = $85   : rem all sorts of operators:
964 tkw.plus     = $01   : rem +
966 tkw.minus    = $02   : rem -
968 tkw.mulf     = $03   : rem *
970 tkw.divf     = $04   : rem /
972 tkw.ge       = $05   : rem >=
974 tkw.gt       = $06   : rem >
976 tkw.apeq     = $07   : rem ==
978 tkw.eq       = $08   : rem =
980 tkw.ne       = $09   : rem <>
982 tkw.le       = $0a   : rem <=
984 tkw.lt       = $0b   : rem <
986 tkw.bor      = $0c   : rem ||
988 tkw.band     = $0d   : rem &&
990 tkw.bxor     = $0e   : rem ^^
992 tkw.power    = $0f   : rem ^
994 tkw.cnct     = $10   : rem &
996 tkw.or       = $11   : rem OR
998 tkw.and      = $12   : rem AND
1000 tkw.xor      = $13   : rem XOR
1002 tkw.mod      = $14   : rem MOD
1004 tkw.div      = $15   : rem DIV
1006 tkw.instr    = $16   : rem INSTR
1008
1010 tkb.mon      = $86
1012 tkw.neg      = $01   : rem negate
1014 tkw.pos      = $02   : rem positivel!
1016 tkw.bnot     = $03   : rem ~~
1018 tkw.not      = $04   : rem ~
1020
1022 tkb.name     = $88   : rem $8800 name
1024
1026 tkb.qstr     = $8b   : rem delimited strings
1028 tkw.quote    = $22   : rem string delimited by "quotes"
1030 tkw.apost    = $27   : rem string delimited by 'apostrophes'
1032
1034 tkb.text     = $8c   : rem text (after REMark)
1036 tkw.text     = $00   : rem text (after REMark)
1038
1040 tkb.lno      = $8d   : rem $8d00 line number (word)
1042
1044 tkb.seps     = $8e   : rem all sorts of formatting separators:
1046 tkw.scoma    = $01   : rem separator comma
1048 tkw.scoln    = $02   : rem semicolon
1050 tkw.bslsh    = $03   : rem backslash
1052 tkw.excl     = $04   : rem exclamation mark
1054 tkw.sto      = $05   : rem separator TO
1056 enddef
1058 :
1060 :
