* PRTSTR - screen printing util
*
* VER 0.03%,  PWITTE February 28th 2001, April 17th 2002
* V0.04, pjw, 2021 Jan 23, Channel number or Channel ID
*
        section code

        xdef prtstr

        xref chan_d6            ; link with dev4_sbu_chn_gtchanID_asm
        xref getpars
        xref resrir

*
prtstr
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* er% = PRTSTR%
*      (
*       [#ch%]                        Channel number (def #1)
* or
*       [#ch]                         Qdos channel ID
*
*       [, timeout%]                  Timeout: -1 = forever, 0 = none (def)
*       {                             Repeat this bit:
*        [! atx%, aty%] |              AT char position x/y - always two!
*        [! atx%! aty%]                AT pix position x/y - always two!
*        [TO tabx%]                    TO TAB x-position
*        [\ ink [, strip]]             INK and STRIP colour (mode 0..)
*        [; string[$] | char% [, ]* ]  list of strings or (int%) char bytes
*       }                             End repeated parameters
*      )
*
*       $27 = QL,  $50 = pal, $54 = true color, $58 = native

        moveq #0,d5
        move.b $bd(a6),d5       d5 is colour mode
        bne.s newcol

        moveq #$27,d5           prime for QL-colours

newcol
        moveq #0,d4             d4 = default timeout = 0
        moveq #0,d7             d7 = last sep
        moveq #1,d6             d6 = default channel is #1

        bsr.s get_sep           type of seperator after this par (if any)
        bsr get_type            type of par
        move.b d0,d2            keepsafe

        bsr chan_d6             get chan number.w or chan ID.l
        bne exit

        tst.b d2
        beq.s nul               nul parameter must be skipped
*                               a0 = chan ID
        cmpi.b #$10,d7           comma?
        bne.s loop               nope

        bsr.s getint             yep, get one integer for timeout
        move.w d1,d4            d4 = timeout
*
loop
        cmpi.b #$30,d7          backslash?
        blo.s cs                comma or semi
        bhi et                  exclaim or TO
*
slash                         ; ink and strip
        moveq #-1,d2             set solid colour (for now)
        bsr.s getlong

        bsr setink              returns soft error on error

        cmpi.b #$10,d7
        bne.s loop              not ours

        bsr.s getlong

        bsr setstrip            returns soft error on error

        bra.s loop
*
nul
        addq.l #8,a3            skip blank par
        cmpa.l a3,a5            end of pars?
        bcs.s exit_bp            yep, must be joking
        bra.s loop              enter the treadmill
*
getlong
        bsr.s get_sep
        moveq #$16,d0           get one long
        bsr getpars
        bne.s sub_exit

        move.l 0(a6,a1.l),d1
        addq.l #4,$58(a6)
        rts
*
getint
        bsr.s get_sep
        moveq #$10,d0           get one integer
        bsr getpars
        bne.s sub_exit

        move.w 0(a6,a1.l),d1
        addq.l #2,$58(a6)
        rts
*
get_sep
        move.b 1(a6,a3.l),d7    see what sort of seperator this is
        andi.w #%01110000,d7    sep mask (if end error = 0.l)
        rts
*
sstrg
        moveq #$7,d0            iob.smul

        trap #4                 a6 rel
*
trap3
        move.w d4,d3            set timeout
        trap #3
        tst.l d0
        beq.s exit

        addq.l #4,a7            dont return to caller
*
return
        move.w d0,d3            save error
        moveq #2,d1             reserve two bytes for int return
        bsr resrir

        move.w d3,0(a6,a1.l)    return "soft" error to SB
        moveq #3,d4             ret int
        moveq #0,d0
        rts

*
cs                            ; comma or semi-colon
        cmpi.b #$20,d7
        beq.s semi

        tst.b d7                the end?
        beq.s return
*
exit_bp
        moveq #-15,d0           comma here is wrong
*
exit
        rts
*
sub_exit
        addq.l #4,a7
        rts
*
get_type
        move.b 1(a6,a3.l),d0    see what sort of parameter this is
        andi.b #$0f,d0
        cmpi.b #2,d0            binary test
        rts
*
outloop
        cmpi.b #$10,d7
        bne loop
*
semi
        bsr.s get_type
        bls.s get_str           anything not an integer is a string

        bsr.s getint            get "byte" to send
        moveq #$5,d0            iob.sbyt
        bsr.s trap3

        bra.s outloop           do it again, sam
*
to
        cmpi.b #$50,d7          just to make sure..
        bne.s exit_bp
        bsr.s getint
        moveq #$11,d0           iow.scol
        bsr trap3
        bra loop

*
get_str
        bsr.s get_sep
        moveq #$14,d0           get one string
        bsr getpars
        bne.s exit

        move.w 0(a6,a1.l),d2    get length
        moveq #3,d6
        add.w d2,d6
        bclr #0,d6              amount of stack space taken
        addq.l #2,a1            a1 (+a6) -> start of string bytes

        bsr.s sstrg             write string
        add.l d6,$58(a6)        tidy string off stack
        bra.s outloop
*
et                            ; exclamation mark and TO

        cmpi.b #$40,d7
        bhi.s to

exclaim
        bsr getint
        move.w d1,d2
        cmpi.b #$40,d7
        bne.s scur

        bsr getint
        moveq #$17,d0           iow.spix
        bra.s iow

scur
        bsr getint
        moveq #$10,d0           iow.scur

iow
        exg d1,d2
        bsr trap3
        bra loop

*
setstrip
        moveq #1,d0             set strip
        bra.s setis
*
setink
        moveq #2,d0             set ink
*
setis
        cmpi.b #$54,d5          trucolor?
        bne.s ns
        lsl.l #8,d1             colour left-aligned
ns
        add.w d5,d0             add colour type offset
        bra trap3

*
        end
