100 rem $$chan=7
102 rem $$stak=2048
104 rem $$heap=1024
106 rem $$asmb=dev1_qv_bin_QV_BIN,0,10
108 rem $$asmb=dev1_qv_bin_BMPCVT_BIN,0,10
110 rem -$$asmb=dev1_qv_bin_PHGTK_bin,0,10
112 rem -$$asmb=dev1_qv_bin_CV2NAT_bin,0,10
114 :
116 rem QView - Simple Graphics Viewer
118 rem V0.01, pjw, September 11th 2018
120 rem V0.12, pjw, 2020 Dec 04
122 rem V0.13, pjw, 2023 Apr 24, see history
124 :
126 rem Expects Qlib_run, ptrmen_cde, and PHGTK to be pre-loaded
128 EXT_PROC 'CV64TONAT', 'CV33TONAT', 'CV32TONAT', 'CV16TONAT'
130 EXT_PROC 'SET_SSPR', 'OUTLSZ', 'WINDSZ', 'QLIBJN', 'DERLE', 'SPT', 'GPT'
132 EXT_PROC 'WL_BMPCVT32', 'WL_BMPCVT33': rem For now..
134 EXT_FN 'MN_VIEW', 'MN_MENU', 'MN_SUB', 'SP_CORB', 'SP_TIME'
136 EXT_FN 'SP_MENU', 'SP_F2', 'SP_F3', 'SP_TRAN'
138 EXT_FN 'VALID%', 'DETAB$', 'GUESS', 'ENRLE', 'GET_SSPR'
140 EXT_FN 'ERRM$', 'ODD', 'LOWER$', 'RPT%', 'GETCOL%'
142 :
144 rem     Config Home Directory - for HOT_RES etc. Dont fiddle in SBASIC!
146 Config$="<<QCFX>>01 QV 0.13 R          Home directory )                                           "
148 :
150 root$ = home_dir$: if root$ = '': root$ = Config$(57 to 56+code(Config$(56)))
152 :
154 dmode% = disp_type
156 :
158 cml$ = CMD$
160 :
162 rem $$off
164 rem     Development code. (Not included in compiled program.)
166 rem             ###  Bmp2Pic unfinished! ###
168 if peek$(\\ -4, 4) = 'SBAS' then
170  lrespr home_dir$ & 'bin_QV_BIN': lrespr'win4_gfx_rle_ENRLE_BIN': rem ###
172  lrespr home_dir$ & 'bin_BMPCVT_BIN'
174  sel on dmode%
176   = 16: lrespr 'win4_tks_col_CV216_BIN'
178   = 32: lrespr 'win4_tks_col_CV232_BIN'
180   = 33: lrespr 'win4_tks_col_CV233_BIN'
182   = remainder: ert -19
184  endsel
186 endif
188 :
190 if cml$ = '' then
192  rem cml$ = '/T 11 /Fwin3_gfx_Goodtime.jpg'
194  cml$ = '/F win3_dmp_beach512x384_scr /X512 /Y384 /M33 /P3'
196  cml$ = '/F win3_tst_Azerbajan_pic'
198  rem cml$ = '/F ram1_beach33_psa'
200  cml$ = '/F win3_dmp_big_Worm_scr4'
202  cml$ = 'win3_dmp_psion_pic'
204  cml$ = '/F"win3_dbg_qdt_qdtg1600x1200_SCR" /P3'
206  rem cml$ = '/F win3_bmp_test_bmp': rem Doesnt work
208  rem cml$ = '/Fwin3_bmp_Housefly_sc32 /X308 /P2 /Rwin2_util_view'
210  rem cml$ = '/F win3_tmp_beach512x384_scr /P2'
212 endif
214 rem     End development code
216 rem $$on
218 :
220 if cml$ = '': quit
222 :
224 rem     Basic window and sub menu metrics
226 osx%  =  124: osy% =  126:      rem Outline size
228 wsx%  =  120: wsy% =  104:      rem Window size
230 wdx%  = osx% - wsx% + 1: wdy% = osy% - wsy%: rem Delta
232 wmx%  = wsx%: wmy% = wsy%:      rem Minimum window size
234 oox%  =   -1: ooy% =   -1:      rem Default origen at pointer pos
236 menx% = 100:                    rem F2/F3 menu hit width + margin
238 :
240 rem     Various constants
242 rem  WM colours
244 sp_titlebg%     = 516: rem $0204 Title background
246 sp_titletextbg% = 517: rem Title text background
248 sp_titlefg%     = 518: rem Title foreground
250 sp_litemavafg%  = 521: rem Loose item available foreground
252 sp_infwinbg%    = 527: rem Information window background
254 sp_infwinfg%    = 528: rem Information window foreground
256 sp_infwinmg%    = 529: rem Information window middleground
258 :
260 rem Window Working Definition offsets
262 ww_xorg         =  36: rem .w  $24  x origin of window
264 ww_yorg         =  38: rem .w  $26  y origin of window
266 :
268 rem Menus
270 aw_tit%  =  1:  rem Title Application Window
272 aw_dis%  =  2:  rem Display Application Window
274 aw_disr% =  aw_dis% - 1: rem AW as seen by PI internally
276 :
278 rem Loose Items
280 li_resz% = -1
282 li_wake% = -2
284 li_slep% = -3
286 li_quit% = -4
288 li_wmov% = -5
290 :
292 rem Events
294 ev_time%  =   0: rem Timed out
296 ev_quit%  =   1: rem Kill
298 ev_sleep% =   2: rem Sleep
300 ev_wake%  =   4: rem Wake
302 ev_done%  =   8: rem Finished
304 ev_tile%  =  32: rem Tile
306 ev_casc%  =  64: rem Cascade
308 ev_all%   = 127: rem All valid events %01111111
310 ev_rpt%   = ev_all%
312 :
314 rem Fuction keys
316 f2% = 236
318 f3% = 240
320 :
322 rem Graphics types
324 gt_unk%  =  0:  rem Unknown, usually scr
326 gt_pic%  =  1:  rem Standard pic files (further details in header)
328 gt_psa%  =  2:  rem Pic file with extra info (as spec'ed in QRAM)
330 gt_spr%  =  3:  rem Any sprite (details in its header)
332 gt_scr%  =  4:  rem QL screen dump (512x256, mode 0 or 8)!
334 gt_sc0%  =  5:  rem QL screen dump (any size) mode 4
336 gt_sc8%  =  6:  rem QL screen dump (any size) mode 8
338 gt_sc16% =  7:  rem QL screen dump (any size) mode 16
340 gt_sc32% =  8:  rem QL screen dump (any size) mode 32
342 gt_sc33% =  9:  rem QL screen dump (any size) mode 33
344 gt_sc64% = 10:  rem QL screen dump (any size) mode 64 (?)
346 gt_jpg%  = 11:  rem Any JPEG file supported by PHGTK
348 gt_png%  = 12:  rem Any PNG file supported by PHGTK
350 gt_gif%  = 13:  rem Any GIF file supported by PHGTK
352 gt_zxd%  = 14:  rem Any ZXD file supported by PHGTK
354 gt_bmp%  = 15:  rem Any bmp file supported by WL_BMP2PIC
356 gt_pac%  = 16:  rem RLE-compressed PIC
358 :
360 rem Misc
362 quote$   = '"' & "'":    rem Quote charcters
364 flag%    = 19196: rem $4AFC
366 co       =    -1: rem No display channels yet
368 scale%   =     0: rem Scaling flag
370 filter%  =     1: rem Smoothing filter
372 rzbt%    =     2: rem Resize border thickness
374 rzbc%    =   228: rem Resize border colour
376 rztv%    =     9: rem Resize termination vector
378 irt%     =    48: rem Termination vector: Immediate ReTurn
380 sgfx$    =    '': rem Only filled in when gfx is scaled
382 gfx$     =    '': rem Temp name goes here
384 orfan    =     0: rem "Owner" alive (= 0) or not (= 1)
386 b256%    =   256: rem 256
388 Mb1      = 1048576: rem 1024 * 1024
390 Mb4      = Mb1 * 4
392 :
394 dim er$(100):                   rem GLOBal error text
396 dim pr%(15), jn$(22):           rem Pointer Record. Limit jobname
398 dim Extn$(33, 5), Extn%(33):    rem Extensions
400 dim xdim%(14), ydim%(15):       rem "Standard" dump dimensions
402 :
404 rem + ------------------------------------------------------------------------ +
406 rem The following code does the startup logic for when QV is not part of QPV   |
408 rem QPV will already have done all the work before QV gets here.               |
410 rem + ------------------------------------------------------------------------ +
412 :
414 restore
416 rem     Additions must be in alphabetical order
418 for i% = 0 to dimn(Extn$): read Extn$(i%), Extn%(i%)
420 data '',      gt_unk%
422 data 'bmp',   gt_bmp%
424 data 'dmp',   gt_scr%
426 data 'dmp0',  gt_sc0%
428 data 'dmp8',  gt_sc8%
430 data 'dmp16', gt_sc16%
432 data 'dmp32', gt_sc32%
434 data 'dmp33', gt_sc33%
436 data 'dmp64', gt_sc64%
438 data 'gif',   gt_gif%
440 data 'jpeg',  gt_jpg%
442 data 'jpg',   gt_jpg%
444 data 'pac',   gt_pac%
446 data 'pcc',   gt_pac%
448 data 'pic',   gt_pic%
450 data 'png',   gt_png%
452 data 'psa',   gt_psa%
454 data 'sc0',   gt_sc0%
456 data 'sc4',   gt_sc0%
458 data 'sc8',   gt_sc8%
460 data 'sc16',  gt_sc16%
462 data 'sc32',  gt_sc32%
464 data 'sc33',  gt_sc33%
466 data 'sc64',  gt_sc64%
468 data 'scr',   gt_scr%
470 data 'scr0',  gt_sc0%
472 data 'scr4',  gt_sc0%
474 data 'scr8',  gt_sc8%
476 data 'scr16', gt_sc16%
478 data 'scr32', gt_sc32%
480 data 'scr33', gt_sc33%
482 data 'scr64', gt_sc64%
484 data 'spr',   gt_spr%
486 data 'zxd',   gt_zxd%
488 :
490 rem     Possible x/y size combinations
492 FOR i% = 0 TO DIMN(xdim%): READ xdim%(i%)
494 FOR i% = 0 TO DIMN(ydim%): READ ydim%(i%)
496 DATA 256, 512, 640, 720, 768, 800, 1024, 1280, 1360, 1366, 1400, 1440, 1600, 1680, 1920
498 DATA 256, 280, 350, 384, 480, 512, 576, 600, 720, 768, 800, 900, 960, 1024, 1050, 1080
500 :
502 rem Command line must be read before config. Sort out the mess afterwards
504 config = 0
506 er = GetCmd(cml$): if er < 0: Bye er, cml$
508 er = GetConfig
510 if er < 0 then
512  if er$ = '' then
514   Bye er, 'Cannot find QV_cfg'
516  else
518   Bye er, 'Parsing config: ' & er$
520  endif
522 endif
524 if len(pal$): palette = GetPal(pal$)
526 Setpal
528 config = 1: rem Bye needs to know..
530 :
532 rem     Get gfx type, unless already known
534 if typ% < 0 then
536  typ% = BSearch%(lower$(xt$), Extn$)
538  if typ% < 0: Bye -19, 'Type not known'
540  typ% = Extn%(typ%)
542 endif
544 :
546 :
548 rem + ************************************************************************ +
550 rem *<                          Convert and Display                           >*
552 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
554 rem *   Screen dumps are sent to GetDump to determin what they are (if poss)   *
556 rem *   All gfxes are converted to PICs via Convert.                           *
558 rem *   The resulting PIC is prepared for viewing (scaled, centred).           *
560 rem *   The F3 menu is prepared (SetPattern, CHG_COL etc) and                  *
562 rem *   The display is set up (DisInit). Finally the image is displayed        *
564 rem + ------------------------------------------------------------------------ +
566 rem * V0.01, pjw, 2019 ++                                                      *
568 rem * V0.02, pjw, 2019 Sep 09, Additional test for mode                        *
570 rem * V0.03, pjw, 2020 Oct 21, Functionalised GetDump and Convert              *
572 rem + ************************************************************************ +
574 :
576 :
578 sel on typ%
580  = gt_unk%, gt_scr% to gt_sc64%
582    er = GetDump: if er < 0: Bye er, er$
584 endsel
586 :
588 rem     "Owner" ID (if any)
590 if oid <= 0 then
592  jnroot$ = 'QV '
594 else
596  h$ = hex$(oid, 32)
598  jnroot$ = 'QV_' & h$(5 to 8) & ' '
600  if job$(oid) = '': oid = -1: rem Fake oid
602 endif
604 jn$ = jnroot$ & nm$: qlibjn jn$
606 :
608 rem Test if temp is a dynamic RAM drive (Use of this feature has been neglected)
610 DynRAM tmp$
612 :
614 gfx$ = tmp$ & 'orig_pic'
616 :
618 er = Convert: if er < 0: Bye er, er$
620 :
622 rem     Prepare to draw menu
624 ch = fop_in(gfx$): if ch < 0: Bye ch, 'Opening ' & gfx$
626 if flen(#ch) < 10: Bye -15, gfx$ & ': Not a valid file!'
628 wget#ch; f%, gsx%, gsy%, llen%: bget#ch; gmode%
630 close#ch
632 ogsx% = gsx%: ogsy% = gsy%: rem Remember original gfx size
634 :
636 DisInit
638 SetPattern: CHG_COL#ch, sp_litemavafg%: rem Setup Blob colour for F3 menu, etc
640 pic = 0
642 :
644 rem     Sort out initial display
646 if scale$ == 'fit' and filldis = 0 then
648  if gsx% < wsx% and gsy% < wsy% then
650   if upscale$ == 'yes' then
652    ReScale
654   else
656    LoadPic gfx$
658   endif
660  else
662   ReScale
664  endif
666 else
668  LoadPic gfx$
670 endif
672 :
674 Centre
676 :
678 :
680 rem + ************************************************************************ +
682 rem *<                                  Main                                  >*
684 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
686 rem *                        Main user interaction loop                        *
688 rem *                                                                          *
690 rem + ************************************************************************ +
692 :
694 :
696 eve% = wait_event(255, 0):      rem Clear any pending events
698 events% = ev_all% * b256%: eve% = events%
700 x% = -1: y% = -1: to% = x%: tv% = 9
702 rep main
704  k = mcallt(#co\ eve%, to%, k, st%): pval#co; pr%
706  if pr%(6): Keys pr%(6)
708  s% = pr%(5):   rem Q-Lib doesnt allow sel on array
710  sel on k
712   = li_resz%
714     sel on s%: = 1, 2: Resize s%
716   = li_wake%
718     if oid <= 0 then
720      if s% = 2: WakeUp
722     else
724      if Not Orphan(oid): ptop#co; oid: rem Temporary usage?
726     endif
728   = li_slep%
730     if s% = 2: Broadcast ev_sleep%
732     Sleep
734   = li_quit%
736     if s% = 2: WakeUp: KillAll: rem Broadcast ev_quit%
738     Bye 0, ''
740     :
742   = aw_dis%: ReadDis
744   = aw_tit%: rem , li_wmov%
746     rem CF4 doesn work for some reason, so handling code removed
748     if s% then
750      wmov#co; -1
752      outlsz#co; osx%, osy%, oox%, ooy%
754      FixUp
756      mwlink#co\ aw_dis%, #cw
758     endif
760   = -1280: rem                           ***  Events
762     ev% = eve% div b256%
764     DoEvent
766     eve% = events%: er = wait_event(255, 0)
768  endsel
770 endrep main
772 Bye 0, ''
774 :
776 :
778 rem + ************************************************************************ +
780 rem *<                        User Interaction Routines                       >*
782 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
784 rem *      Mainly subroutines of Main loop, so uses all GLOBal variables       *
786 rem *                                                                          *
788 rem + ------------------------------------------------------------------------ +
790 rem * V0.01, pjw, 2018 Sep 11++                                                *
792 rem + ************************************************************************ +
794 :
796 :
798 rem + ------------------------------------------------------------------------ +
800 rem |<                            Read Display AW                             >|
802 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
804 rem |              Reads and interprets various user-interactions              |
806 rem |     ..and dispatches program flow to the various processing routines.    |
808 rem |                    Also responds to external signals.                    |
810 rem |                                                                          |
812 rem | Sub-routine off global main loop, so uses its LOCals.                    |
814 rem + ------------------------------------------------------------------------ +
816 rem | V0.01, pjw, 2019 Aug++                                                   |
818 rem | V0.02, pjw, 2019 Nov 17, Generalised & expanded to include F2            |
820 rem | V0.02, pjw, 2020 Sep 23, Hover F2 disabled, as annoying!                 |
822 rem + ------------------------------------------------------------------------ +
824 :
826 def proc ReadDis
828 loc lp, x%, y%, k%, mx%, my%
830 mx% = (wsx% - menx%) / 2
832 my% = (wsy% - menx%) / 2
834 toggle = 1
836 mwindow#co\ aw_dis%
838 rep lp
840  if rpt%(#co; tv%! ev_rpt%, x%, y%, -1) <> aw_disr%: exit lp
842  ev% = ev_rpt% div b256%
844  if ev%: DoEvent
846  :
848  k% = tv% div b256%: if k% < 0: k% = k% + b256%
850  sel on k%
852   = 0: rem Do nothing
854   = 1: if gsx% > dsx% or gsy% > dsy%: MoveGfx
856   = 2: ReScale
858   = 218 to 223: MoveGfx
860   = remainder: Keys k%
862  endsel
864  :
866  sel on x%
868   = wsx% - 8 to wsx% + 2
870     sel on y%
872      = wsy% - 8 to wsy% + 2
874        BRC: if ev%: DoEvent
876        exit lp
878     endsel
880  = mx% - menx% to mx% + menx%
882     sel on y%
884      = 0 to 6: if toggle: Menu f3%, k%: sprs#co; 0
886      rem = my% - menx% to my% + menx%: if toggle: Menu f2%, k%: sprs#co; 0
888      = remainder: toggle = 1
890     endsel
892   = remainder: toggle = 1
894  endsel
896  :
898 endrep lp
900 enddef ReadDis
902 :
904 :
906 rem + ------------------------------------------------------------------------ +
908 rem |<                          Bottom Right Corner                           >|
910 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
912 rem |               Interprets pointer position re BRC resizing                |
914 rem |                          Dispatches on Click                             |
916 rem + ------------------------------------------------------------------------ +
918 rem | V0.01, pjw, 2019 Aug++                                                   |
920 rem + ------------------------------------------------------------------------ +
922 :
924 def proc BRC
926 loc clp
928 sprs#co; SP_CORB
930 rep clp
932  k% = rpt%(#co; tv%! ev_rpt%, x%, y%, -1)
934  if k% <> aw_disr%: exit clp
936  ev% = ev_rpt% div b256%: if ev%: exit clp
938  if x% > (wsx% + 2) or x% < (wsx% - 8): exit clp
940  if y% > (wsy% + 2) or y% < (wsy% - 8): exit clp
942  k% = tv% div b256%
944  sel on k%: = 1, 2: ReszBRC: exit clp
946 endrep clp
948 sprs#co; 0
950 enddef BRC
952 :
954 :
956 rem + ------------------------------------------------------------------------ +
958 rem |<                                 Menu                                   >|
960 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
962 rem |                         Experimental popup menu                          |
964 rem |                                                                          |
966 rem | f3 +v => F3 pressed: Start immediately; 0 => scan and wait               |
968 rem |                                                                          |
970 rem | GLOBal ev_rpt%, ev%, oox%, menx%, (minx%) + window metrics               |
972 rem + ------------------------------------------------------------------------ +
974 rem | V0.01, pjw, 2019 Aug 25                                                  |
976 rem + ------------------------------------------------------------------------ +
978 :
980 def proc Menu(fx%, kp%)
982 loc mlp, k%, x%, y%
984 sel on fx%
986  = f2%: sprs#co; SP_F2
988  = f3%: sprs#co; SP_F3
990 endsel
992 :
994 if not kp% then
996  rep mlp
998   if rpt%(#co; tv%! ev_rpt%, x%, y%, mn_tio%) <> aw_disr%: ret
1000   ev% = ev_rpt% div b256%: if ev%: DoEvent: ret
1002   :
1004   k% = tv% div b256%
1006   sel on k%: = -1, 1, 2: exit mlp
1008   :
1010   sel on x%
1012    = mx% - menx% to mx% + menx%
1014      sel on y%
1016       = 0 to 6
1018       = my% - menx% to my% + menx%
1020       = remainder: sprs#co; 0: toggle = 0: ret
1022      endsel
1024    = remainder: sprs#co; 0: toggle = 0: ret
1026   endsel
1028   :
1030  endrep mlp
1032 endif
1034 :
1036 sel on fx%
1038  = f2%: F2Menu
1040  = f3%: F3Menu
1042 endsel
1044 sprs#co; 0
1046 toggle = 0
1048 enddef Menu
1050 :
1052 :
1054 rem + ------------------------------------------------------------------------ +
1056 rem |<                                  Keys                                  >|
1058 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1060 rem |                   Main action routine for keypresses.                    |
1062 rem |                                                                          |
1064 rem | Sub-routine of caller; uses caller's LOCals                              |
1066 rem + ------------------------------------------------------------------------ +
1068 rem | V0.01, pjw, 2019 Jul 16                                                  |
1070 rem | V0.02, pjw, 2020 Oct 15, variable move keys                              |
1072 rem + ------------------------------------------------------------------------ +
1074 :
1076 def proc Keys(key%)
1078 sel on key%
1080  =  0 to 2: rem Do Nothing
1082  = 27: Bye 0, ''
1084  = 67, 99:  Broadcast ev_casc%
1086  = 73, 105, 232: Info:             rem Info on gfx
1088  = 82, 114: er = SavePac(k% = 114): if er < 0: Burp: else: beep 2000, 20
1090  = 83, 115: er = SavePic(k% = 115): if er < 0: Burp: else: Ping
1092  = 84, 116: Broadcast ev_tile%
1094    :
1096  = 144 to 153: Transform key%
1098  = kfL1%,kfL2%,kfL3: gox% = gox% + fast%: rem LEFT fast   - A/S/A+S
1100  = kfU1%,kfU2%,kfU3%: goy% = goy% - fast%: rem UP fast
1102  = kfR1%,kfR2%,kfR3%: gox% = gox% - fast%: rem RIGHT fast
1104  = kfD1%,kfD2%,kfD3%: goy% = goy% + fast%: rem DOWN fast
1106    :
1108  = ksL1%,ksL2%:     gox% = gox% +  1: rem LEFT 1      - C/A+C/S+C
1110  = ksU1%,ksU2%:     goy% = goy% -  1: rem UP 1
1112  = ksR1%,ksR2%:     gox% = gox% -  1: rem RIGHT 1
1114  = ksD1%,ksD2%:     goy% = goy% +  1: rem DOWN 1
1116    :
1118  = kmL%: gox% = gsx%:              rem LEFT max    - A+S+C
1120  = kmU%: goy% = 0   :              rem UP max
1122  = kmR%: gox% = 0:                 rem RIGHT max
1124  = kmD%: goy% = gsy%:              rem DOWN max
1126    :
1128  = f2%, f3%: Menu key%, 1:        rem Menus
1130  rem = remainder: at#co; 10,0: print#co; key%,
1132 endsel
1134 enddef Keys
1136 :
1138 :
1140 rem + ------------------------------------------------------------------------ +
1142 rem |<                                 Events                                 >|
1144 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1146 rem |                      Main action routine for Events                      |
1148 rem |                                                                          |
1150 rem | Sub-routine of caller; uses caller's LOCals                              |
1152 rem + ------------------------------------------------------------------------ +
1154 rem | V0.02, pjw, 2019 Aug 20, isolated                                        |
1156 rem + ------------------------------------------------------------------------ +
1158 :
1160 def proc DoEvent
1162 sel on ev%
1164  = ev_time%  : rem Timed out
1166  = ev_quit%  : Bye 0, ''
1168  = ev_sleep% : Sleep
1170  = ev_wake%  : WakeUp
1172  = ev_done%  : rem Just clear this
1174  = ev_tile%  : Tile
1176  = ev_casc% to ev_all%: Cascade ev%
1178 endsel
1180 enddef DoEvent
1182 :
1184 :
1186 rem + ------------------------------------------------------------------------ +
1188 rem |<                                MoveGfx                                 >|
1190 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1192 rem |                       Move graphics within window.                       |
1194 rem |                                                                          |
1196 rem | Routine reacts to dragging or keystrokes (including scroll wheel)        |
1198 rem + ------------------------------------------------------------------------ +
1200 rem | V0.01, pjw, 2018 Sep                                                     |
1202 rem + ------------------------------------------------------------------------ +
1204 :
1206 def proc MoveGfx
1208 loc rl, k%
1210 rem Sub routine of main
1212 :
1214 mwindow#co\ aw_dis%
1216 rep rl
1218  rdpt#co; tv%: pval#co; pr%
1220  if pr%(2) = -1: exit rl
1222  k% = pr%(6): Keys k%
1224  if k% > 192: ReDraw
1226  :
1228  lx% = x%: ly% = y%: x% = pr%(3): y% = pr%(4)
1230  if pr%(5) <> 0 then
1232   dx% = lx% - x%
1234   dy% = ly% - y%
1236   if dx% or dy% then
1238    gox% = gox% + dx%
1240    goy% = goy% + dy%
1242    ReDraw
1244   endif
1246  endif
1248 endrep rl
1250 mwindow#co\ 0
1252 enddef MoveGfx
1254 :
1256 :
1258 rem + ------------------------------------------------------------------------ +
1260 rem |<                                 Resize                                 >|
1262 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1264 rem |                        Resize using top left icon                        |
1266 rem |                                                                          |
1268 rem | HIT and drag icon to desired position, or DO icon for optimal size       |
1270 rem | HIT resets scaleing flag scale%                                          |
1272 rem + ------------------------------------------------------------------------ +
1274 rem | V0.01, pjw, 2018 Sep                                                     |
1276 rem + ------------------------------------------------------------------------ +
1278 :
1280 def proc Resize(s%)
1282 if s% = 2 then
1284  if filldis then
1286   wsx% = winx%: wsy% = winy%
1288  else
1290   wsx% = gsx%: wsy% = gsy%
1292  endif
1294  filldis = not filldis
1296  Limits
1298  mclear#co: Centre
1300 else
1302  wsize#co; x%, y%
1304  wsx% = wsx% - x%
1306  wsy% = wsy% - y%
1308  oox% = oox% + x%
1310  ooy% = ooy% + y%
1312  filldis = 0:           rem No longer fills display
1314  scale% = 0:            rem New scaling allowed
1316  Limits
1318  mclear#co: Centre
1320  winx% = osx%: winy% = osy%
1322 endif
1324 :
1326 x% = oox% + 10: y% = ooy% + 10
1328 rdpt#co; irt%, x%, y%
1330 enddef Resize
1332 :
1334 :
1336 rem + ------------------------------------------------------------------------ +
1338 rem |<                       Resize Bottom Right Corner                       >|
1340 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1342 rem |                        Alternative resize routine                        |
1344 rem |                                                                          |
1346 rem | Experimental interface - There are many different ways one could do      |
1348 rem | this!                                                                    |
1350 rem + ------------------------------------------------------------------------ +
1352 rem | V0.01, pjw, 2018 Sep 25                                                  |
1354 rem | V0.02, pjw, 2020 Dec 04, added +CTRL for proportional resize.            |
1356 rem + ------------------------------------------------------------------------ +
1358 :
1360 def proc ReszBRC
1362 loc rc, bsx%, bsy%, x%, y%, lx%, ly%
1364 loc dx%, dy%, wx%, wy%, gx%, gy%
1366 loc sx%, sy%, ox%, oy%, rat
1368 :
1370 windsz#cw; sx%, sy%, ox%, oy%
1372 sx% = sx% - 2: ox% = ox% - 2:           rem Display window size
1374 sy% = sy% - wdy%: oy% = oy% - wdy%
1376 close#cw: close#co
1378 :
1380 rc = fopen("con_")
1382 colour_24
1384 bsx% = ssx% - oox%: bsy% = ssy% - ooy%
1386 outl#rc; bsx%, bsy%, oox%, ooy%, 0, 0
1388 alpha_blend#rc; 100
1390 block#rc; bsx%, bsy%, 0, 0, 100
1392 sprs#rc; SP_CORB
1394 :
1396 wx% = ox% - oox%: wy% = oy% - ooy%
1398 :
1400 dx% = gsx% - gox% - wx%
1402 if dx% > bsx%: dx% = bsx% - wx%
1404 :
1406 dy% = gsy% - goy% - wy%
1408 if dy% > bsy%: dy% = bsy% - wy%
1410 :
1412 wsars#rc; pic\ dx%, dy%, wx%, wy%, gox%, goy%
1414 :
1416 rat = gsx% / gsy%:                      rem gfx X/Y ratio
1418 if rat <= 0: rat = 1
1420 :
1422 colour_ql: alpha_blend#rc; 255
1424 paper#rc; 0: ink#rc; 7: over#rc; -1
1426 x% = sx%: y% = sy%: lx% = x%: ly% = y%
1428 bsx% = bsx% - rzbt%: bsy% = bsy% - rzbt%
1430 :
1432 Displ lx%, ly%
1434 block#rc; rzbt%, bsy%, x%, 0, rzbc%
1436 block#rc; bsx%, rzbt%, 0, y%, rzbc%
1438 gpt x%, y%: rem y% = -y%: rdpt#rc; irt%, x%, y%
1440 :
1442 when err: gpt x%, y%: retry: endwhen:   rem RDPT sometimes bombs out when compiled..
1444 rep rzl
1446  rdpt#rc; rztv%, x%, y%: pval#rc; pr%
1448  Xhairs pr%(3), pr%(4)
1450  if pr%(5) or pr%(6) = 27: exit rzl
1452 endrep rzl
1454 close#rc
1456 when err: endwhen
1458 :
1460 if pr%(5) = 2 then
1462  winx% = x% - ox%: winy% = y% - oy%
1464  scale% = 0:                            rem Re-scaling allowed
1466 endif
1468 :
1470 DisInit
1472 Centre:                                 rem Need parameters to leave gox/y intact
1474 enddef ReszBRC
1476 :
1478 DEFine PROCedure Xhairs(x%, y%)
1480 if keyrow(7) = 2: y% = x% / rat: spt#rc; 1, x%, y%
1482 :
1484 IF x% >= bsx% or x% < wmx%: ret
1486 IF y% >= bsy% or y% < wmy%: ret
1488 :
1490 BLOCK#rc; rzbt%, bsy%, lx%, 0, rzbc%
1492 BLOCK#rc; bsx%, rzbt%, 0, ly%, rzbc%
1494 :
1496 BLOCK#rc; rzbt%, bsy%, x%, 0, rzbc%
1498 BLOCK#rc; bsx%, rzbt%, 0, y%, rzbc%
1500 :
1502 Displ lx%, ly%
1504 Displ x%, y%
1506 :
1508 lx% = x%: ly% = y%
1510 END DEFine Xhairs
1512 :
1514 :
1516 DEFine PROCedure Displ(px%, py%)
1518 LOCal x%, y%, l%, s$
1520 s$ = ' ' & px% & '/' & py% & ' ': l% = LEN(s$) * 6
1522 x% = px% - l% - 6: y% = py% - 12
1524 BLOCK#rc; l% - 8, 10, x% + 4, y%, 7
1526 CURSOR#rc; x%, y%: PRINT#rc; s$;
1528 END DEFine Displ
1530 :
1532 :
1534 :
1536 rem + ************************************************************************ +
1538 rem *<                         Misc Triaging Routines                         >*
1540 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1542 rem | Deal with those pesky screen dumps..                                     |
1544 rem |                                                                          |
1546 rem | A bloody mess! Needs a complete re-think (yet again)                     |
1548 rem + ------------------------------------------------------------------------ +
1550 rem * V0.01, pjw, 2020 Oct 21                                                  *
1552 rem * V0.02, pjw, 2020 Nov-Dec                                                 *
1554 rem + ************************************************************************ +
1556 :
1558 def fn GetDump
1560 if typ% = gt_scr% then
1562  rem If mode given on CMD, set type
1564  sel on gmd%
1566   = -1: rem Do nothing
1568   =  0, 4: typ% = gt_sc0%  : gmode% =  0
1570   =  8:    typ% = gt_sc8%  : gmode% = gmd%
1572   = 16:    typ% = gt_sc16% : gmode% = gmd%
1574   = 32:    typ% = gt_sc32% : gmode% = gmd%
1576   = 33:    typ% = gt_sc33% : gmode% = gmd%
1578   = remainder: er$ = 'Type': ret -19
1580  endsel
1582 endif
1584 :
1586 if gsx% < 0 or gsy% < 0 then
1588  rem Size not given, so try to guess
1590  sel on typ%
1592   = gt_scr%: rem Try all
1594     if srcfln <= Mb1: Size08
1596     if gsx% < 0 and srcfln <= Mb4: Size16
1598     if gsx% < 0: Size3X
1600   = gt_sc0%, gt_sc8% : Size08
1602   = gt_sc16%: Size16
1604   = gt_sc32%, gt_sc33%: Size3X
1606  endsel
1608  if gsx% < 0 then
1610   if not RezUnkn(srcfln, gsx%, gsy%, gmd%) then
1612    er$ = 'Cant guess size': ret -15
1614   endif
1616  endif
1618 endif
1620 :
1622 if gmd% = -1 then
1624  sel on typ%
1626   = gt_sc0% : gmd% =  0
1628   = gt_sc8% : gmd% =  8
1630   = gt_sc16%: gmd% = 16
1632   = gt_sc32%: gmd% = 32
1634   = gt_sc33%: gmd% = 33
1636  endsel
1638  gmd% = dmode%
1640 endif
1642 :
1644 sel on gmd%
1646  = 16: typ% = gt_sc16%
1648  = 32: typ% = gt_sc32%
1650  = 33: typ% = gt_sc33%
1652 endsel
1654 gmode% = gmd%
1656 :
1658 ret 0
1660 enddef GetDump
1662 :
1664 :
1666 rem + ------------------------------------------------------------------------ +
1668 rem |<                                Convert                                 >|
1670 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1672 rem |                  Convert gfx using appropriate routine                   |
1674 rem |                                                                          |
1676 rem | Relies on various conversion sub routines                                |
1678 rem |                                                                          |
1680 rem | Sets  GLOBal er$ - error message                                         |
1682 rem | Reads GLOBal mxp                                                         |
1684 rem + ------------------------------------------------------------------------ +
1686 rem | V0.01, pjw, 2018 Sep ++                                                  |
1688 rem | V0.02, pjw, 2020 Oct 14, added PAC as separate entry. Some small fixes   |
1690 rem | V0.03, pjw, 2020 Oct 21, made into function for easy re-use              |
1692 rem + ------------------------------------------------------------------------ +
1694 :
1696 def fn Convert
1698 er$ = fnm$
1700 sel on typ%
1702  = gt_unk%:     rem Unknown, usually scr
1704    er = -19: er$ = 'Type unknown: ' & er$
1706    :
1708  = gt_pic%:     rem Standard pic files (further details in header)
1710    er = Pic2Mode: rem Convert (If necessary)
1712    :
1714  = gt_psa%:     rem Pic file with extra info (as spec'ed in QRAM)
1716    er = PSA2Mode
1718    :
1720  = gt_spr%:     rem Any sprite (details in its header)
1722    type$ = 'Sprite mode'
1724    rem er = -19:    rem We dont deal with these (yet?)
1726    er = Spr2Pic
1728    :
1730  = gt_scr%:     rem QL screen dump (512x256, mode 0 or 8)!
1732    er = Scr
1734    :
1736  = gt_sc0%:     rem QL screen dump (any size) mode 4
1738    type$ = 'Dump mode': gmd% = 0
1740    gsy% = fscr(fnm$, gfx$, dmode%, gsx%)
1742    er = gsy%
1744    :
1746  = gt_sc8%:     rem QL screen dump (any size) mode 8
1748    type$ = 'Dump mode': gmd% = 8
1750    gsy% = fscr8(fnm$, gfx$, dmode%, gsx% / 2)
1752    er = gsy%
1754    :
1756  = gt_sc16%:    rem QL screen dump (any size) mode 16
1758    type$ = 'Dump mode': gmd% = 16
1760    er = Dmp2Pic(gsx%)
1762    :
1764  = gt_sc32%:    rem QL screen dump (any size) mode 32
1766    type$ = 'Dump mode': gmd% = 32
1768    er = Dmp2Pic(gsx% + gsx%)
1770    :
1772  = gt_sc33%:    rem QL screen dump (any size) mode 33
1774    type$ = 'Dump mode': gmd% = 33
1776    er = Dmp2Pic(gsx% + gsx%)
1778    :
1780  = gt_sc64%:    rem QL screen dump (any size) mode 64 (?)
1782    type$ = 'Headerless dump mode': gmd% = 64
1784    er = Dmp2Pic(4 * gsx%)
1786    :
1788  = gt_jpg%:     rem Any JPEG file supported by PHGTK
1790    type$ = 'JPEG'
1792    er = MemOK(Mpeg(fnm$, dmode%))
1794    if er >= 0: er = fjpeg(fnm$, gfx$, dmode%)
1796    :
1798  = gt_png%:     rem Any PNG file supported by PHGTK
1800    type$ = 'PNG'
1802    er = MemOK(mpng(fnm$, dmode%))
1804    if er >= 0: er = fpng(fnm$, gfx$, dmode%)
1806    :
1808  = gt_gif%:     rem Any GIF file supported by PHGTK
1810    type$ = 'GIF'
1812    er = MemOK(mgif(fnm$, dmode%))
1814    if er >= 0: er = fgif(fnm$, gfx$, dmode%)
1816    :
1818  = gt_zxd%:     rem Any ZXD file supported by PHGTK
1820    type$ = 'Spectrum ZXD'
1822    er = MemOK(mzxd(fnm$, dmode%))
1824    if er >= 0: er = fzxd(fnm$, gfx$, dmode%)
1826    :
1828  = gt_bmp%:    rem BMP2PIC
1830    type$ = 'BMP'
1832    er = Bmp2Pic: if er < 0: return er: rem Bmp2Pic sets er$
1834    :
1836  = gt_pac%:     rem Compressed pic files (further details in header)
1838    type$ = 'RLE-compressed PIC'
1840    er = RLE2Mode: rem Convert (If necessary)
1842    :
1844  = remainder
1846    er = -19
1848    :
1850 endsel
1852 ret er
1854 enddef Convert
1856 :
1858 :
1860 :
1862 rem + ************************************************************************ +
1864 rem *<                            Display Routines                            >*
1866 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1868 rem *                                                                          *
1870 rem + ************************************************************************ +
1872 :
1874 :
1876 rem + ------------------------------------------------------------------------ +
1878 rem |<                                Dis Init                                >|
1880 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1882 rem |                         (Re-) Initialise display                         |
1884 rem |                                                                          |
1886 rem | Sets GLOBal: co, cw, ssx%, ssy%, wsx%, wsy% - screen & window metrics    |
1888 rem + ------------------------------------------------------------------------ +
1890 rem | V0.01, pjw, 2018 Sep                                                     |
1892 rem + ------------------------------------------------------------------------ +
1894 :
1896 def proc DisInit
1898 co = fopen("con_")
1900 cw = fopen("con_")
1902 flim#co; ssx%, ssy%, sox%, soy%
1904 :
1906 if winx% = -1 then
1908  wsx% = gsx%: winx% = gsx%: filldis = 1
1910  wsy% = gsy%: winy% = gsy%
1912 else
1914  wsx% = winx%: filldis = 0
1916  wsy% = winy%
1918 endif
1920 :
1922 Limits
1924 :
1926 if oox% = -1 then
1928  if orgx% = -2 then
1930   oox% = (ssx% - osx%) / 2
1932  else
1934   oox% = orgx%
1936  endif
1938 endif
1940 :
1942 if ooy% = -1 then
1944  if orgy% = -2 then
1946   ooy% = (ssy% - osy%) / 2 + 12
1948  else
1950   ooy% = orgy%
1952  endif
1954 endif
1956 colour_24
1958 end def DisInit
1960 :
1962 :
1964 rem + ------------------------------------------------------------------------ +
1966 rem |<                                 ReDraw                                 >|
1968 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1970 rem |              Redraw gfx in window based on current metrics               |
1972 rem |                                                                          |
1974 rem + ------------------------------------------------------------------------ +
1976 rem | V0.01, pjw, 2018 Oct 01                                                  |
1978 rem + ------------------------------------------------------------------------ +
1980 :
1982 def proc ReDraw
1984 if gox% < 0 then
1986  gox% = 0
1988 else
1990  if gox% > (gsx% - dsx%): gox% = gsx% - dsx%
1992 endif
1994 :
1996 if goy% < 0 then
1998  goy% = 0
2000 else
2002  if goy% > (gsy% - dsy%): goy% = gsy% - dsy%
2004 endif
2006 wsars#cw; pic\ dsx%, dsy%, wox%, woy%, gox%, goy%
2008 enddef ReDraw
2010 :
2012 :
2014 rem + ------------------------------------------------------------------------ +
2016 rem |<                                 Limits                                 >|
2018 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
2020 rem |                    Check window limits within screen                     |
2022 rem |                                                                          |
2024 rem + ------------------------------------------------------------------------ +
2026 rem | V0.01, pjw, 2018 Sep                                                     |
2028 rem + ------------------------------------------------------------------------ +
2030 :
2032 def proc Limits
2034 if wsx% < wmx% then
2036  wsx% = wmx%
2038 else
2040  if wsx% > (ssx% - wdx% - 12) then
2042   wsx% = ssx% - wdx% - 12: rem Extra for shadow
2044   oox% = 2
2046  endif
2048 endif
2050 :
2052 if wsy% < wmy% then
2054  wsy% = wmy%
2056 else
2058  if wsy% > (ssy% - wdy% - 20) then
2060   wsy% = ssy% - wdy% - 20: rem Extra for shadow and button bar
2062   ooy% = 12
2064  endif
2066 endif
2068 :
2070 osx% = wsx% + wdx%: osy% = wsy% + wdy%
2072 enddef Limits
2074 :
2076 :
2078 rem + ------------------------------------------------------------------------ +
2080 rem |<                                 Centre                                 >|
2082 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
2084 rem |                      Center graphics within window                       |
2086 rem |                                                                          |
2088 rem + ------------------------------------------------------------------------ +
2090 rem | V0.01, pjw, 2018 Sep                                                     |
2092 rem + ------------------------------------------------------------------------ +
2094 :
2096 def proc Centre
2098 if gsx% < wsx% then
2100  wox% = (wsx% - gsx%) / 2
2102  dsx% = gsx%
2104 else
2106  wox% = 0
2108  dsx% = wsx%
2110 endif
2112 :
2114 if gsy% < wsy% then
2116  woy% = (wsy% - gsy%) / 2
2118  dsy% = gsy%
2120 else
2122  woy% = 0
2124  dsy% = wsy%
2126 endif
2128 gox% = 0: goy% = 0
2130 :
2132 ert Orphan(oid)
2134 mdraw#co; MN_VIEW, oox%, ooy%, osx%, osy%
2136 rem mdraw#co; MEN_VIEW, oox%, ooy%, osx%, osy%
2138 Title#co; fnm$
2140 outlsz#co; osx%, osy%, oox%, ooy%
2142 mwlink#co\ aw_dis%, #cw
2144 paper#cw; fillc: cls#cw
2146 ink#cw; 0
2148 wsars#cw; pic\ dsx%, dsy%, wox%, woy%, gox%, goy%
2150 enddef Centre
2152 :
2154 :
2156 rem + ------------------------------------------------------------------------ +
2158 rem |<                                 Title                                  >|
2160 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
2162 rem |                      Display filename on title bar                       |
2164 rem |                                                                          |
2166 rem | Uses WINDSZ and Compact$ which allows file name - or part - to be        |
2168 rem | displayed at "any" width                                                 |
2170 rem + ------------------------------------------------------------------------ +
2172 rem | V0.01, pjw, 2018 Sep 23                                                  |
2174 rem + ------------------------------------------------------------------------ +
2176 :
2178 def proc Title(ch, txt$)
2180 loc sx%, sy%, ox%, oy%
2182 mwindow#ch, aw_tit%
2184 wm_ink#ch; sp_titlefg%: wm_strip#ch; sp_titletextbg%
2186 windsz#ch; sx%, sy%, ox%, oy%
2188 :
2190 l% = len(txt$) * 6
2192 if (l% + 8) > sx%: l% = sx% - 8
2194 ox% = (sx% - l% - 4) / 2
2196 oy% = (sy% - 12) / 2
2198 :
2200 wm_block#ch; l% + 4, 12, ox%, oy%, sp_titletextbg%
2202 cursor#ch; ox% + 2, oy% + 1
2204 bput#ch; Compact$(txt$, int(l% / 6))
2206 enddef Title
2208 :
2210 :
2212 rem + ------------------------------------------------------------------------ +
2214 rem |<                                 Fixup                                  >|
2216 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
2218 rem |                        Fix up window after wmove                         |
2220 rem |                                                                          |
2222 rem | Set main window origin after move mode 0 move (WTF??!)                   |
2224 rem | Is this a bug in the WM.CHWIN code, WMOV, or ..?                         |
2226 rem + ------------------------------------------------------------------------ +
2228 rem | V0.01, pjw, 2020 May 03                                                  |
2230 rem + ------------------------------------------------------------------------ +
2232 :
2234 def proc Fixup
2236 loc wwd
2238 wwd  = mwdef(#co):              rem Window def
2240 poke_w wwd + ww_xorg, oox% + 2: rem Border width?
2242 poke_w wwd + ww_yorg, ooy% + 1
2244 enddef Fixup
2246 :
2248 :
2250 :
2252 rem + ************************************************************************ +
2254 rem *<                      Graphics Manipulation Routines                    >*
2256 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
2258 rem * Convert foreign gfxes to Pic. Scaling etc                                *
2260 rem *                                                                          *
2262 rem + ------------------------------------------------------------------------ +
2264 rem * V0.01, pjw, 2018                                                         *
2266 rem + ************************************************************************ +
2268 :
2270 :
2272 rem + ------------------------------------------------------------------------ +
2274 rem |<                                 Rotate                                 >|
2276 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
2278 rem |                         Flip or rotate an image                          |
2280 rem |                                                                          |
2282 rem | GLOBal: pic, sgfx$, gfx$                                                 |
2284 rem + ------------------------------------------------------------------------ +
2286 rem | V0.01, pjw, 2019 Oct 31                                                  |
2288 rem + ------------------------------------------------------------------------ +
2290 :
2292 def proc Transform(k%)
2294 loc t%
2296 t% = k% - 144
2298 if not pic: ret
2300 if scale% = 0 then
2302  sgfx$ = tmp$ & 'scale_pic'
2304  er = fpic_transform(gfx$, sgfx$, t%, -4)
2306 else
2308  er = fpic_transform(sgfx$, sgfx$, t%, -4)
2310 endif
2312 :
2314 if er >= 0 then
2316  scale% = 1
2318  rechp pic
2320  LoadPic sgfx$
2322  Centre
2324 endif
2326 enddef Transform
2328 :
2330 :
2332 rem + ------------------------------------------------------------------------ +
2334 rem |<                                Re-scale                                >|
2336 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
2338 rem |                       Toggle various scale states                        |
2340 rem |                                                                          |
2342 rem | Scale to fit window, or reset scale to full size.                        |
2344 rem | Switch between scaled view (fit) or full size view (part view, within    |
2346 rem | a given window size).                                                    |
2348 rem | A resize of window is required for a new scale.                          |
2350 rem | scale% = the flag that controls the states.                              |
2352 rem | Reads GLOBal ogsx%, ogsy% (non-scaled original pic size)                 |
2354 rem | Sets  GLOBal sgfx$, gsx%, gsy%                                           |
2356 rem + ------------------------------------------------------------------------ +
2358 rem | V0.01, pjw, 2018 Sep 22                                                  |
2360 rem | V0.02, pjw, 2019 Oct 31, simplified                                      |
2362 rem + ------------------------------------------------------------------------ +
2364 :
2366 def proc ReScale
2368 loc x%, y%
2370 sel on scale%
2372  = 0: rem New or first scaling
2374       if gsx% = wsx% and gsy% = wsy%: ret
2376       :
2378       rem Alter system Wait sprite to dynamic Time sprite
2380       ops = get_sspr(5)
2382       set_sspr 5, SP_TIME
2384       :
2386       x% = wsx%
2388       y% = int(wsx% * gsy% / gsx%)
2390       if y% > wsy% then
2392        y% = wsy%
2394        x% = int(wsy% * gsx% / gsy%)
2396       endif
2398       gsx% = x%: gsy% = y%
2400       sgfx$ = tmp$ & 'scale_pic'
2402       if pic: rechp pic: pic = 0
2404       if x% * 8 > gsx% or y% * 8 > gsy% then
2406        er = fpic_filter(gfx$, sgfx$, filter%): rem Smoothing for extreme reduction
2408        if er >= 0 then
2410         er = fpic_scale(sgfx$, sgfx$, gsx%, gsy%)
2412        endif
2414       else
2416        er = fpic_scale(gfx$, sgfx$, gsx%, gsy%)
2418       endif
2420       :
2422       set_sspr 5, ops: ops = 0: rem Reset system sprite
2424       :
2426       if er < 0 then
2428        Burp
2430        gsx% = ogsx%: gsy% = ogsy%
2432        LoadPic gfx$
2434       else
2436        LoadPic sgfx$
2438        scale% = 2
2440       endif
2442  = 1: rem Restore previously scaled
2444       if pic: rechp pic
2446       LoadPic sgfx$
2448       scale% = 2
2450  = 2: rem Restore original
2452       if pic: rechp pic
2454       LoadPic gfx$
2456       scale% = 1
2458  = remainder: ret
2460 endsel
2462 :
2464 Centre
2466 enddef ReScale
2468 :
2470 :
2472 rem + ------------------------------------------------------------------------ +
2474 rem |<                                LoadPic                                 >|
2476 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
2478 rem |                          Load PIC into display                           |
2480 rem |                                                                          |
2482 rem | (Free memory routine not working, also disregarded many places)          |
2484 rem + ------------------------------------------------------------------------ +
2486 rem | V0.01, pjw, 2018 Sep 16                                                  |
2488 rem | V0.02, pjw, 2020 Nov 24, Use actual file size! (duh!)                    |
2490 rem + ------------------------------------------------------------------------ +
2492 :
2494 def proc LoadPic(fnm$)
2496 loc ch, fl, sz
2498 er$ = 'Loading PIC'
2500 ch = fop_in(fnm$): if ch < 0: Bye ch, er$
2502 fl = flen(#ch): wget#ch\ 2, gsx%, gsy%, llen%: close#ch
2504 sz = 10 + gsy% * llen%
2506 if sz < fl: sz = fl: rem Use largest size!
2508 pic = GetMem(sz): rem wsain(#cw; gsx%, gsy%) <- Dumb: If file sz > estimate => BANG!
2510 lbytes fnm$, pic
2512 enddef LoadPic
2514 :
2516 :
2518 rem + ------------------------------------------------------------------------ +
2520 rem |<                              Pic to Mode                               >|
2522 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
2524 rem |                  Convert a pic to correct display mode                   |
2526 rem |                                                                          |
2528 rem | GLOBal srcfln, dmode%, gfx$; sets gmode%                                 |
2530 rem + ------------------------------------------------------------------------ +
2532 rem | V0.01, pjw, 2018 Sep 16                                                  |
2534 rem | V0.02, pjw, 2019 Aug 16, re-wrote with new conversion routines           |
2536 rem | V0.03, pjw, 2020 Dec 10, GetMem                                          |
2538 rem + ------------------------------------------------------------------------ +
2540 :
2542 def fn Pic2Mode
2544 loc ch, adr
2546 ch = fopen(fnm$): if ch < 0: ret ch
2548 bget#ch\ 8, gmode%: gmd% = gmode%
2550 close#ch
2552 :
2554 type$ = 'PIC mode': rem & gmode%
2556 sel on gmode%
2558  = 0, 4, 8: ret fpic_ql(fnm$, gfx$, dmode%)
2560 endsel
2562 :
2564 er$ = 'Converting PIC'
2566 adr = GetMem(srcfln)
2568 lbytes fnm$, adr
2570 er = CVtoNAT(adr, srcfln)
2572 rechp adr: ret er
2574 :
2576 enddef Pic2Mode
2578 :
2580 :
2582 rem + ------------------------------------------------------------------------ +
2584 rem |<                                CVtoNAT                                 >|
2586 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
2588 rem |              Convert Pic from any GD2 mode to Current mode               |
2590 rem | Inputs:                                                                  |
2592 rem |   pic  -> PIC header + source pic,                                       |
2594 rem |   fl   =  PIC length (ie data + 10b header)                              |
2596 rem | Returns:                                                                 |
2598 rem |   0   => Conversion ok                                                   |
2600 rem |   -v  => Error                                                           |
2602 rem | Doesnt release original buffer                                           |
2604 rem | GLOBal gmode%, dmode%, gfx$                                              |
2606 rem + ------------------------------------------------------------------------ +
2608 rem | V0.01, pjw, 2019 Aug 16, new conversion routines                         |
2610 rem | V0.02, pjw, 2019 Nov 16, bug fix: line lenghts <> multiples of x         |
2612 rem + ------------------------------------------------------------------------ +
2614 :
2616 :
2618 def fn CVtoNAT(pic, fl)
2620 loc pico, flo, ll%, llo%
2622 :
2624 rem Assume inputs = outputs (until they arent)
2626 pico = pic: flo = fl
2628 ll% = peek_w(pic + 6): llo% = ll%
2630 :
2632 sel on dmode%
2634  = 16
2636    sel on gmode%
2638     = 16: rem Nothing more to do
2640     = 32, 33: llo% = ll% div 2
2642       if gmode% = 32 then
2644        CV32TONAT pic + 10, pico + 10, fl - 10
2646       else
2648        CV33TONAT pic + 10, pico + 10, fl - 10
2650       endif
2652     = 64: llo% = ll% div 4
2654       CV64TONAT pic + 10, pico + 10, fl - 10
2656     = remainder: ret -19
2658    endsel
2660    flo = 10 + llo% * peek_w(pic + 4)
2662    poke_w pico + 6, llo%
2664    :
2666  = 32, 33
2668    sel on gmode%
2670     = 16: llo% = ll% * 2
2672       flo = 10 + llo% * peek_w(pic + 4)
2674       er$ = 'CV2NAT 16 -> 3x'
2676       pico = GetMem(flo)
2678       poke$ pico, peek$(pic, 10)
2680       poke_w pico + 6, llo%
2682       CV16TONAT pic + 10, pico + 10, fl - 10
2684     = 32: CV32TONAT pic + 10, pic + 10, fl - 10
2686     = 33: CV33TONAT pic + 10, pic + 10, fl - 10
2688     = 64: llo% = ll% div 2
2690       CV64TONAT pic + 10, pic + 10, fl - 10
2692       flo = 10 + llo% * peek_w(pic + 4)
2694       poke_w pico + 6, llo%
2696     = remainder: ret -19
2698    endsel
2700 endsel
2702 :
2704 poke pico + 8, dmode%
2706 sbytes_o gfx$, pico, flo
2708 :
2710 REMark release extra heap area used
2712 if pic <> pico: rechp pico
2714 ret 0
2716 enddef CVtoNAT
2718 :
2720 :
2722 rem + ------------------------------------------------------------------------ +
2724 rem |<                              PSA to Mode                               >|
2726 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
2728 rem | Convert a PSA-type file to pic and convert to display mode if necessary  |
2730 rem |                                                                          |
2732 rem + ------------------------------------------------------------------------ +
2734 rem | V0.01, pjw, 2018 Sep 19                                                  |
2736 rem | V0.03, pjw, 2019 Aug 17, re-write                                        |
2738 rem | V0.04, pjw, 2020 Dec 10, MemOK -> GetMem                                 |
2740 rem + ------------------------------------------------------------------------ +
2742 :
2744 def fn PSA2Mode
2746 loc adr, dat
2748 er$ = 'PSA to Mode'
2750 adr = GetMem(srcfln)
2752 lbytes fnm$, adr
2754 :
2756 rem     Check if its just a RLE-compressed PIC
2758 if peek$(adr, 3) = 'RLE' and peek_w(adr + 4) = flag% then
2760  type$ = 'PAC mode ': rem & gmode%
2762  ret RLE2Md
2764 endif
2766 :
2768 rem     Find start of pic
2770 for dat = adr to adr + 38 step 2
2772  if peek_w(dat) = flag%: exit dat
2774 endfor dat
2776 if peek_w(dat) <> flag%: rechp adr: ret -15: rem This can be any sort of PSA file?
2778 :
2780 gmode% = peek(dat + 8)
2782 type$ = 'PSA mode ': rem & gmode%
2784 sel on gmode%
2786  = 0, 4, 8
2788    sbytes_o gfx$, dat, srcfln - dat + adr
2790    rechp adr
2792    ret fpic_ql(gfx$, gfx$, dmode%)
2794 endsel
2796 :
2798 er = CVtoNAT(dat, srcfln - dat + adr)
2800 rechp adr: ret er
2802 enddef PSA2Mode
2804 :
2806 :
2808 rem + ------------------------------------------------------------------------ +
2810 rem |<                                RLE2Mode                                >|
2812 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
2814 rem |          Decompress a PAC and convert to correct display mode            |
2816 rem |                                                                          |
2818 rem | As it stands, a sub routine of PSA2Mode                                  |
2820 rem + ------------------------------------------------------------------------ +
2822 rem | V0.01, pjw, 2020 Apr 10                                                  |
2824 rem | V0.02, pjw, 2020 Oct 11, prepended new layer to separate from PSA2Mode   |
2826 rem | V0.03, pjw, 2020 Dec 10, MemOK -> GetMem                                 |
2828 rem + ------------------------------------------------------------------------ +
2830 :
2832 def fn RLE2Mode
2834 loc adr
2836 er$ = 'RLE to Mode'
2838 adr = GetMem(srcfln)
2840 lbytes fnm$, adr
2842 :
2844 rem     Check if its just a RLE-compressed PIC
2846 if peek$(adr, 3) = 'RLE' and peek_w(adr + 4) = flag% then
2848  type$ = 'PAC mode ': rem & gmode%
2850  ret RLE2Md
2852 else
2854  rechp adr
2856 endif
2858 ret -19
2860 enddef RLE2Mode
2862 :
2864 def fn RLE2Md
2866 loc pic, sz, md%
2868 md% = peek(adr + 3) - 48
2870 gmode% = peek(adr + 12)
2872 :
2874 sel on gmode%
2876  = 0, 4, 8, 16, 32, 33, 64:  gmd% = gmode%: rem Ok modes
2878  = remainder
2880    rechp adr: ret -19:  rem RLEd QL modes not implemented
2882 endsel
2884 :
2886 sz = peek_w(adr + 8) * peek_w(adr + 10)
2888 :
2890 pic = GetMem(sz + 10)
2892 DERLE adr + 14, pic + 10, sz, md%
2894 poke$ pic, peek$(adr + 4, 10)
2896 :
2898 sel on gmode%
2900  = 0, 4, 8
2902    sbytes_o gfx$, pic, sz + 10
2904    rechp pic
2906    rechp adr
2908    ret fpic_ql(gfx$, gfx$, dmode%)
2910 endsel
2912 :
2914 er = CVtoNAT(pic, sz + 10)
2916 rechp pic
2918 rechp adr
2920 ret er
2922 enddef RLE2Md
2924 :
2926 :
2928 rem + ------------------------------------------------------------------------ +
2930 rem |<                              Dump to Pic                               >|
2932 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
2934 rem |          Convert a screen dump to a pic of current display mode          |
2936 rem |                                                                          |
2938 rem | The size, line length and mode must already be known. These are found    |
2940 rem | in the                                                                   |
2942 rem | GLOBal variables gmode%, gsx%, gsy% (also flag%)                         |
2944 rem | The gfx'es line length in ll%                                            |
2946 rem + ------------------------------------------------------------------------ +
2948 rem | V0.01, pjw, 2018 Sep 19                                                  |
2950 rem | V0.02, pjw, 2019 Aug 17, re-write using new conversion routines          |
2952 rem | V0.03, pjw, 2020 Dec 10, MemOK -> GetMem                                 |
2954 rem + ------------------------------------------------------------------------ +
2956 :
2958 def fn Dmp2Pic(ll%)
2960 loc adr
2962 type$ = 'Dump mode': rem & gmode%
2964 er$ = 'Dump to PIC'
2966 adr = GetMem(srcfln + 10)
2968 lbytes fnm$, adr + 10
2970 poke_w adr, flag%, gsx%, gsy%, ll%: rem CVtoNAT sets mode
2972 er = CVtoNAT(adr, srcfln + 10)
2974 rechp adr: ret er
2976 enddef Dmp2Pic
2978 :
2980 :
2982 rem + ------------------------------------------------------------------------ +
2984 rem |<                                  Scr                                   >|
2986 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
2988 rem |          Assess and try to convert an unknown (QL) screen dump           |
2990 rem |                                                                          |
2992 rem | (Perhaps this should have been sorted out at the Convert stage..)        |
2994 rem + ------------------------------------------------------------------------ +
2996 rem | V0.01, pjw, 2018 Sep 19                                                  |
2998 rem | V0.02, pjw, 2020 Dec 10, MemOK -> GetMem                                 |
3000 rem + ------------------------------------------------------------------------ +
3002 :
3004 def fn Scr
3006 loc fl, adr, g
3008 fl  = srcfln
3010 er$ = 'Convert Scr'
3012 adr = GetMem(fl)
3014 lbytes fnm$, adr
3016 g = GUESS(adr, fl): rechp adr
3018 Type$ = 'Dump mode': gmd% = g
3020 :
3022 sel on g
3024  = 0: rem mode 0/4
3026    gsy% = fscr(fnm$, gfx$, dmode%, gsx%)
3028    ret gsy%
3030    :
3032  = 8: rem mode 8
3034    gsy% = fscr8(fnm$, gfx$, dmode%, gsx% / 2)
3036    ret gsy%
3038 endsel
3040 ret g
3042 enddef Scr
3044 :
3046 :
3048 rem + ------------------------------------------------------------------------ +
3050 rem |<                            Guess Dimensions                            >|
3052 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
3054 rem |                   Given filesize and type, guess X & Y                   |
3056 rem |                                                                          |
3058 rem | Often more than one solution possible! This stops at first               |
3060 rem + ------------------------------------------------------------------------ +
3062 rem | V0.01, pjw, 2017 Dec 29++                                                |
3064 rem | V0.02, pjw, 2019 Jul 05 (bespoke and much simplified)                    |
3066 rem | V0.03, pjw, 2019 Sep 09, Added: If one dimension given..                 |
3068 rem + ------------------------------------------------------------------------ +
3070 :
3072 def proc Size08
3074 loc x
3076 if gsx% >= 0 then
3078  x = 4 * srcfln / gsx%
3080  if x = int(x): gsy% = x: ret
3082 else
3084  if gsy% >= 0 then
3086   x = 4 * srcfln / gsy%
3088   if x = int(x): gsx% = x: ret
3090  endif
3092 endif
3094 :
3096 TryXSize srcfln * 4, 0
3098 enddef Size08
3100 :
3102 def proc Size16
3104 loc x
3106 if gsx% >= 0 then
3108  x = srcfln / gsx%
3110  if x = int(x): gsy% = x: ret
3112 else
3114  if gsy% >= 0 then
3116   x = srcfln / gsy%
3118   if x = int(x): gsx% = x: ret
3120  endif
3122 endif
3124 :
3126 TryXSize srcfln, 1
3128 enddef Size16
3130 :
3132 def proc Size3X
3134 loc x
3136 if gsx% >= 0 then
3138  x = srcfln / 2 / gsx%
3140  if x = int(x): gsy% = x: ret
3142 else
3144  if gsy% >= 0 then
3146   x = srcfln / 2 / gsy%
3148   if x = int(x): gsx% = x: ret
3150  endif
3152 endif
3154 :
3156 TryXSize srcfln / 2, 2
3158 enddef Size3X
3160 :
3162 :
3164 DEFine PROCedure TryXsize(fl, m%)
3166 loc i%, mb%, ty%, t
3168 rem GLOBal xdim%, ydim%
3170 :
3172 FOR i% = 0 TO DIMN(xdim%)
3174  t = fl / xdim%(i%)
3176  ty% = GetYsize%(t)
3178  IF ty% THEN
3180   sel on m%
3182    = 0: rem QL modes
3184         gsx% = xdim%(i%): gsy% = ty%
3186         if gmd% = -1: gmd% = 0
3188         exit i%
3190    = 1: rem 8 bit
3192         gsx% = xdim%(i%): gsy% = ty%
3194         if gmd% = -1: gmd% = 16
3196         exit i%
3198    = 2: rem 16 bit
3200         gsx% = xdim%(i%): gsy% = ty%
3202         if gmd% = -1: gmd% = dmode%
3204         exit i%
3206    endsel
3208  END IF
3210 endfor i%
3212 END DEFine TryXsize
3214 :
3216 DEFine FuNction GetYsize%(tz)
3218 LOCal j%, s%
3220 IF i% < 3: s% = 0: ELSE : s% = i% - 2
3222 FOR j% = s% TO DIMN(ydim%)
3224  IF ydim%(j%) >= xdim%(i%): RETurn 0
3226  IF tz = ydim%(j%): RETurn ydim%(j%)
3228 END FOR j%
3230 RETurn 0
3232 END DEFine GetYsize%
3234 :
3236 :
3238 rem + ------------------------------------------------------------------------ +
3240 rem |<                               BMP to PIC                               >|
3242 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
3244 rem |                  Convert various BMP-type files to PIC                   |
3246 rem |                                                                          |
3248 rem | Based on routines from D Jones, updated and maintained bu B Spelten,     |
3250 rem | abreviated and prepared for use here by pjw.                             |
3252 rem + ------------------------------------------------------------------------ +
3254 rem | V0.01, pjw, 2019 Jul 13                                                  |
3256 rem | V0.02, pjw, 2020 Dec 10, MemOK -> GetMem                                 |
3258 rem + ------------------------------------------------------------------------ +
3260 :
3262 def fn Bmp2Pic
3264 loc ch, wl%, wm%, d1%, d2%, hl%, hm%
3266 loc adr, fl
3268 rem GLOBal er$
3270 sel on dmode%: = 32, 33: = remainder: er$ = 'No BMP in mode 16': ret -19
3272 :
3274 rem     Check bmp type
3276 ch = fop_in(fnm$): if ch < 0: er$ = 'File error': ret ch
3278 bget#ch\ 18, wl%, wm%, d1%, d2%, hl%, hm%
3280 bget#ch\ 28, d1%: close#ch
3282 if d1% <> 24: er$ = 'Only 24-bit bmps allowed': ret -19
3284 :
3286 rem     Get sizes and estimate memory requirements
3288 gsx% = wm% * b256% + wl% : gsy% = hm% * b256% + hl%
3290 :
3292 er$ = 'BMP to PIC'
3294 er = MemOK(srcfln + gsx% * 2 * gsy%)
3296 if er < 0: Bye er, er$
3298 :
3300 sel on dmode%
3302  = 32: wl_bmpcvt32 fnm$, gfx$
3304  = 33: wl_bmpcvt33 fnm$, gfx$
3306 endsel
3308 :
3310 fl = flen(\ gfx$): fl = fl + odd(fl) + 10
3312 adr = GetMem(fl)
3314 lbytes gfx$, adr + 10
3316 poke_w adr, flag%, gsx%, gsy%, gsx% + gsx%
3318 poke adr + 8, dmode%
3320 :
3322 sbytes_o gfx$, adr, fl
3324 rechp adr
3326 ret 0
3328 enddef Bmp2Pic
3330 :
3332 :
3334 :
3336 rem + ************************************************************************ +
3338 rem *<                        Config and Command Line                         >*
3340 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
3342 rem *                                                                          *
3344 rem + ************************************************************************ +
3346 :
3348 :
3350 rem + ------------------------------------------------------------------------ +
3352 rem |<                               GetConfig                                >|
3354 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
3356 rem |                Standard, configurable config file reader                 |
3358 rem |                                                                          |
3360 rem | Re-write! This one should be faster, but has the following limitations:  |
3362 rem | All keys must be present and in the correct order!                       |
3364 rem + ------------------------------------------------------------------------ +
3366 rem | V0.01, pjw, 2020 Oct 18, Fresh start                                     |
3368 rem + ------------------------------------------------------------------------ +
3370 :
3372 def fn GetConfig
3374 loc ch, lp, er, p%, l$(100), t$(40), mvk$(24)
3376 :
3378 ch = CheckID(root$ & "QV_cfg", 'QVCFG02', 0)
3380 if ch < 0: ret ch
3382 :
3384 minfree  =  8192:               rem Min free mem
3386 mvk$ = ''
3388 :
3390 er$ = 'Config incomplete'
3392 er = NextLine: if er: ret er
3394 t$ = GtCfgIt$("winx "):    if valid%(3, t$): winx%    = t$: else: er$ = 'winx':    ret -15
3396 er = NextLine: if er: ret er
3398 t$ = GtCfgIt$("winy "):    if valid%(3, t$): winy%    = t$: else: er$ = 'winy':    ret -15
3400 er = NextLine: if er: ret er
3402 t$ = GtCfgIt$("orgx "):    if valid%(3, t$): orgx%    = t$: else: er$ = 'orgx':    ret -15
3404 er = NextLine: if er: ret er
3406 t$ = GtCfgIt$("orgy "):    if valid%(3, t$): orgy%    = t$: else: er$ = 'orgy':    ret -15
3408 er = NextLine: if er: ret er
3410 t$ = GtCfgIt$("scale "):   if len(t$) > 2  : scale$   = t$: else: er$ = 'scale':   ret -15
3412 er = NextLine: if er: ret er
3414 t$ = GtCfgIt$("upscale "): if len(t$) > 1  : upscale$ = t$: else: er$ = 'upscale': ret -15
3416 er = NextLine: if er: ret er
3418 t$ = GtCfgIt$("fill "):    if len(t$) > 1  : fillc$   = t$: else: er$ = 'fill':    ret -15
3420 er = NextLine: if er: ret er
3422 t$ = GtCfgIt$("temp "):    if len(t$) >= 5 : tmp$     = t$: else: er$ = 'temp':    ret -15
3424 er = NextLine: if er: ret er
3426 t$ = GtCfgIt$("palette "): if len(t$)      : pal$     = t$: else: er$ = 'palette': ret -15
3428 er = NextLine: if er: ret er
3430 t$ = GtCfgIt$("asleep "):  if len(t$)      : asleep$  = t$: else: er$ = 'asleep':  ret -15
3432 er = NextLine: if er: ret er
3434 t$ = GtCfgIt$("btsleep "): if len(t$)      : btsleep$ = t$: else: er$ = 'btsleep': ret -15
3436 er = NextLine: if er: ret er
3438 t$ = GtCfgIt$("wait "):    if valid%(3, t$): wait%    = t$: else: er$ = 'wait':    ret -15
3440 er = NextLine: if er: ret er
3442 t$ = GtCfgIt$("timeout "): if valid%(3, t$): mn_tio%  = t$: else: er$ = 'timeout': ret -15
3444 :
3446 rem Movement key codes
3448 er = NextLine: if er: ret er
3450 t$ = GtCfgIt$("fast "):    if valid%(3, t$): fast%   = t$: else: er$ = 'fast'   : ret -15
3452 er = NextLine: if er: ret er
3454 t$ = GtCfgIt$("fastL "):   if len(t$): if kParse(3): er$ = 'fastL': ret -15
3456 er = NextLine: if er: ret er
3458 t$ = GtCfgIt$("fastU "):   if len(t$): if kParse(3): er$ = 'fastU': ret -15
3460 er = NextLine: if er: ret er
3462 t$ = GtCfgIt$("fastR "):   if len(t$): if kParse(3): er$ = 'fastR': ret -15
3464 er = NextLine: if er: ret er
3466 t$ = GtCfgIt$("fastD "):   if len(t$): if kParse(3): er$ = 'fastD': ret -15
3468 er = NextLine: if er: ret er
3470 t$ = GtCfgIt$("slowL "):   if len(t$): if kParse(2): er$ = 'slowL': ret -15
3472 er = NextLine: if er: ret er
3474 t$ = GtCfgIt$("slowU "):   if len(t$): if kParse(2): er$ = 'slowU': ret -15
3476 er = NextLine: if er: ret er
3478 t$ = GtCfgIt$("slowR "):   if len(t$): if kParse(2): er$ = 'slowR': ret -15
3480 er = NextLine: if er: ret er
3482 t$ = GtCfgIt$("slowD "):   if len(t$): if kParse(2): er$ = 'slowD': ret -15
3484 er = NextLine: if er: ret er
3486 t$ = GtCfgIt$("maxL "):    if len(t$): if kParse(1): er$ = 'maxL' : ret -15
3488 er = NextLine: if er: ret er
3490 t$ = GtCfgIt$("maxU "):    if len(t$): if kParse(1): er$ = 'maxU' : ret -15
3492 er = NextLine: if er: ret er
3494 t$ = GtCfgIt$("maxR "):    if len(t$): if kParse(1): er$ = 'maxR' : ret -15
3496 er = NextLine: if er: ret er
3498 t$ = GtCfgIt$("maxD "):    if len(t$): if kParse(1): er$ = 'maxD' : ret -15
3500 close#ch
3502 :
3504 rem     Do temp dir
3506 if tmp$(len(tmp$)) <> '_': tmp$ = tmp$ & '_'
3508 er = fmake_dir(tmp$): if er = -8: er = 0
3510 if er < 0: ret er
3512 t$ = hex$(jobid, 32)
3514 tmp$ = tmp$ & t$(5 to 8) & '_'
3516 er = fmake_dir(tmp$): if er = -8: er = 0
3518 if er < 0: ret er
3520 :
3522 rem     Do palette
3524 if not palset then
3526  if valid%(3, pal$) then
3528   palette = pal$: pal$ = ''
3530  else
3532   if pal$ = '': palette = 0
3534  endif
3536  palset = 1
3538 else
3540  pal$ =''
3542 endif
3544 :
3546 rem     Do Fill colour
3548 er = ValidHex(fillc$, fillc): rem Valid or black
3550 if er < 0: fillc = 0
3552 :
3554 rem     Fill in movement key code
3556 if len(mvk$) <> 24: er$ = 'Move key code error': ret -15
3558 kfL1% = code(mvk$(1))
3560 kfL2% = code(mvk$(2))
3562 kfl3% = code(mvk$(3))
3564 kfU1% = code(mvk$(4))
3566 kfU2% = code(mvk$(5))
3568 kfU3% = code(mvk$(6))
3570 kfR1% = code(mvk$(7))
3572 kfR2% = code(mvk$(8))
3574 kfR3% = code(mvk$(9))
3576 kfD1% = code(mvk$(10))
3578 kfD2% = code(mvk$(11))
3580 kfD3% = code(mvk$(12))
3582 ksL1% = code(mvk$(13))
3584 ksL2% = code(mvk$(14))
3586 ksU1% = code(mvk$(15))
3588 ksU2% = code(mvk$(16))
3590 ksR1% = code(mvk$(17))
3592 ksR2% = code(mvk$(18))
3594 ksD1% = code(mvk$(19))
3596 ksD2% = code(mvk$(20))
3598 kmL%  = code(mvk$(21))
3600 kmU%  = code(mvk$(22))
3602 kmR%  = code(mvk$(23))
3604 kmD%  = code(mvk$(24))
3606 ret 0
3608 enddef GetConfig
3610 :
3612 rem + ------------------------------------------------------------------------ +
3614 rem |<                                NextLine                                >|
3616 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
3618 rem |                        Get next valid config line                        |
3620 rem |                                                                          |
3622 rem | Subroutine of GetConfig; uses its locals                                 |
3624 rem + ------------------------------------------------------------------------ +
3626 rem | V0.01, pjw, 2020 Oct 18                                                  |
3628 rem + ------------------------------------------------------------------------ +
3630 :
3632 def fn NextLine
3634 rep lp
3636  if eof(#ch): ret -10
3638  input#ch; l$
3640  if len(l$) = 0: next lp
3642  if l$(1) = '*': next lp
3644  exit lp
3646 endrep lp
3648 ret 0
3650 enddef NextLine
3652 :
3654 rem + ------------------------------------------------------------------------ +
3656 rem |<                                GtCfgIt$                                >|
3658 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
3660 rem |                       Extract single Config Item                         |
3662 rem |                                                                          |
3664 rem | Subroutine of GetConfig; uses its locals                                 |
3666 rem + ------------------------------------------------------------------------ +
3668 :
3670 def fn GtCfgIt$(it$)
3672 if (it$ instr l$) <> 1: ret ''
3674 p% = '=' instr l$
3676 if p% = 0: ret ''
3678 t$ = DETAB$(l$(p% + 1 to len(l$)))
3680 for p% = 1 to len(t$)
3682  if t$(p%) = ' ': p% = p% - 1: exit p%
3684 endfor p%
3686 ret t$(1 to p%)
3688 enddef GtCfgIt$
3690 :
3692 rem + ------------------------------------------------------------------------ +
3694 rem |<                                 kParse                                 >|
3696 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
3698 rem |                           Parse key code lists                           |
3700 rem |                                                                          |
3702 rem | Subroutine of GetConfig; uses its locals                                 |
3704 rem + ------------------------------------------------------------------------ +
3706 rem | V0.01, pjw, 2020 Oct 18                                                  |
3708 rem + ------------------------------------------------------------------------ +
3710 :
3712 DEFine FuNction kParse(n%)
3714 loc i%, c%
3716 IF n% > 1 THEN
3718  FOR i% = 1 TO n% - 1
3720   IF NOT VALID%(3, t$): RETurn -15
3722   mvk$ = mvk$ & CHR$(t$)
3724   c% = ',' INSTR t$
3726   IF c% = 0: RETurn -15
3728   t$ = t$(c% + 1 TO LEN(t$))
3730  END FOR i%
3732 END IF
3734 IF NOT VALID%(3, t$): RETurn -15
3736 mvk$ = mvk$ & CHR$(t$)
3738 RETurn 0
3740 END DEFine kParse
3742 :
3744 :
3746 rem + ------------------------------------------------------------------------ +
3748 rem |<                                Command Line                            >|
3750 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
3752 rem |                    Parses command line and sets defaults                 |
3754 rem |                                                                          |
3756 rem |  /A address (hex) - either /F or /A. /A is only processed if no /F       |
3758 rem |  /F filename                                                             |
3760 rem |  /M mode - Only for screen dumps, otherwise ignored 0, 4, 8, 16..64      |
3762 rem |  /O owner ID (8-digit hex) - If the palette or gfx are given as an       |
3764 rem |     address then /O MUST also be given, otherwise /O is optional and     |
3766 rem |     will be used as part of QView's job name                             |
3768 rem |  /P palette 0..3, address (hex) or filename (thb). If address, and owner |
3770 rem |     dies, or address and no owner given, palette reverts to 0            |
3772 rem |  /R alternate root. Overrides Config$ and Homedir                        |
3774 rem |  /T type (see elsewhere for details) - If /A is used, a type MUST be     |
3776 rem |     supplied, If both /F and /T are given, /T is used, otherwise the     |
3778 rem |     filename extension is used. But the actual filetype can only be      |
3780 rem |     guessed at.                                                          |
3782 rem |  /X xsize - sizes are in decimal                                         |
3784 rem |  /Y ysize - xsize and ysize are only intended for graphics types that    |
3786 rem |     dont contain size information in their header, ie mainly screen      |
3788 rem |     dumps. If /X and /Y are not specified QView will make a simple guess |
3790 rem |     based on the file extension; if they are specified, the given sizes  |
3792 rem |     will be used.                                                        |
3794 rem + ------------------------------------------------------------------------ +
3796 rem | V0.01, pjw, 2019 Jul 01                                                  |
3798 rem | V0.02, pjw, 2020 May 05, Added root => Changed palette precedence as     |
3800 rem |                          CMD must now be processed before cfg            |
3802 rem | V0.03, pjw, 2020 Oct 11, filename as only string on command line is ok   |
3804 rem + ------------------------------------------------------------------------ +
3806 :
3808 def fn GetCmd(cl$)
3810 loc ch, p%, t$(200)
3812 :
3814 rem     GLOBal Defaults
3816 fnm$    = ''            : rem Filename
3818 srcfln  = -1            : rem Source file length
3820 srcdat  =  0            : rem Source file date
3822 fad     = -1            : rem Fileaddress
3824 oid     = -1            : rem Owner ID
3826 typ%    = -1            : rem Graphics type
3828 gsx%    = -1: gsy% = -1 : rem Graphics dimensions
3830 gmd%    = -1            : rem Gfx mode (screen dumps)
3832 :
3834 if len(cl$) = 0: ret -15
3836 :
3838 if ("/" instr cl$) = 0 then
3840  er = GetName(cl$, dir$, nm$, xt$): if er < 0: ret er
3842  if srcfln < 10: return -12: rem Invalid name, ie including system sprites
3844  fnm$ = cl$
3846  ret 0
3848 endif
3850 :
3852 rem     Get new root (if any)
3854 t$ = Getent$("R")
3856 if t$ <> '' then
3858  if t$(len(t$)) <> '_': root$ = t$ & '_': else: root$ = t$
3860 endif
3862 :
3864 rem     Get file location
3866 t$ = Getent$("F")
3868 if t$ <> '' then
3870  er = GetName(t$, dir$, nm$, xt$): if er < 0: ret er
3872  if srcfln < 10: return -12: rem Invalid name, ie including system sprites
3874  fnm$ = t$
3876 else
3878  rem This bit is not implemented here (yet?)
3880  t$ = Getent$("A")
3882  if t$ <> '' then
3884   Bye -19, 'Address not allowed'
3886   er = ValidHex(t$, fad): if er < 0: ret er
3888   if odd(fad): ret -15
3890  endif
3892 endif
3894 :
3896 rem     Get owner ID
3898 t$ = Getent$("O")
3900 if t$ <> '' then
3902  er = ValidHex(t$, oid): if er < 0: ret er
3904 endif
3906 :
3908 rem     Do palette
3910 t$ = Getent$("P")
3912 if t$ <> '' then
3914  er = ValidHex(t$, palette)
3916  if er < 0: pal$ = t$
3918  palset = 1:            rem Use CMD palette
3920 else
3922  palset = 0:            rem Palette not set: Use cfg
3924 endif
3926 :
3928 rem     Check whether theres a valid owner, where required
3930 if fad > 0 or palette > 3 then
3932  if oid < 0: ret -2
3934  if Orphan: ret -2
3936 endif
3938 :
3940 rem     Get gfx type
3942 t$ = Getent$("T")
3944 if valid%(3, t$): typ% = t$
3946 :
3948 rem     Get gfx x/y size
3950 t$ = Getent$("X")
3952 if valid%(3, t$): gsx% = t$
3954 t$ = Getent$("Y")
3956 if valid%(3, t$): gsy% = t$
3958 t$ = Getent$("M")
3960 if valid%(3, t$): gmd% = t$
3962 :
3964 ret 0
3966 enddef GetCmd
3968 :
3970 def fn Getent$(c$)
3972 rem Caller's cl$, p%, t$
3974 rem Given the character get the entry
3976 rem /C [<spaces>] ["|'] <entry> ["|'] <space> | <space> /C+1 | <eol>
3978 :
3980 p% = '/' & c$ instr cl$
3982 if p% = 0: ret ''
3984 t$ = detab$(cl$(p% + 2 to len(cl$)))
3986 p% = ' /' instr t$
3988 if p% > 0: t$ = t$(1 to p%): else: p% = len(t$)
3990 for p% = len(t$) to 1 step -1
3992  if not t$(p%) instr ' /': exit p%
3994 endfor p%
3996 :
3998 t$ = t$(1 to p%)
4000 if len(t$) > 1 then
4002  p% = t$(1) instr quote$
4004  if p% then
4006   if (t$(len(t$)) instr quote$) = p% then
4008    t$ = t$(2 to len(t$) - 1)
4010   endif: endif: endif
4012 ret t$
4014 enddef Getent$
4016 :
4018 :
4020 rem + ------------------------------------------------------------------------ +
4022 rem |<                           Palette Operations                           >|
4024 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
4026 rem |                                                                          |
4028 rem + ------------------------------------------------------------------------ +
4030 rem | V0.01, pjw, 2019                                                         |
4032 rem | V0.02, pjw, 2020 Dec 10, GetMem                                          |
4034 rem + ------------------------------------------------------------------------ +
4036 :
4038 def fn GetPal(p$)
4040 loc ch, fl, p
4042 if len(p$) < 10: ret 0:  rem devN_x_thb = min fnm len
4044 ch = fop_in(p$): if ch < 0: ret 0
4046 fl = flen(#ch): close#ch
4048 if fl <> 114: ret 0
4050 er$ = 'Loading palette'
4052 p = GetMem(fl)
4054 lbytes p$, p
4056 ret p
4058 enddef GetPal
4060 :
4062 def proc Setpal
4064 sel on palette
4066  = 0 to 3
4068  = remainder
4070    if odd(palette) or palette < 0 then
4072     palette = 0
4074    else
4076     sp_jobownpal -1, palette: rem Use calling job's private palette
4078     ret
4080    endif
4082 endsel
4084 sp_jobpal -1, palette:       rem Use system palette
4086 enddef Setpal
4088 :
4090 :
4092 rem + ------------------------------------------------------------------------ +
4094 rem |<                                CheckID                                 >|
4096 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
4098 rem | Open an IDed file and check for correct ID                               |
4100 rem |                                                                          |
4102 rem | If ok, return its open channel, with file pointer just past ID           |
4104 rem | io parameter: 0 = read only, 1 => read/write                             |
4106 rem + ------------------------------------------------------------------------ +
4108 :
4110 def fn CheckID(fnm$, id$, io)
4112 loc ch, p%, c$
4114 if io then
4116  ch = fopen(fnm$)
4118 else
4120  ch = fop_in(fnm$)
4122 endif
4124 if ch < 0: ret ch
4126 for p% = 1 to len(id$)
4128  c$ = inkey$(#ch; 50)
4130  if eof(#ch) or len(c$) = 0 or c$ <> id$(p%) then
4132   close#ch: ret -12: rem Not our config file
4134  endif
4136 endfor p%
4138 ret ch
4140 enddef CheckID
4142 :
4144 :
4146 :
4148 rem + ************************************************************************ +
4150 rem *<                         Various Help Routines                          >*
4152 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
4154 rem *                                                                          *
4156 rem *                                                                          *
4158 rem + ------------------------------------------------------------------------ +
4160 rem * V0.01, pjw, 2018                                                         *
4162 rem + ************************************************************************ +
4164 :
4166 :
4168 def proc Bye(er, er$)
4170 if config then
4172  if ops: set_sspr 5, ops
4174  if not gfx$ == fnm$: e = fdel(gfx$)
4176  if len(sgfx$): e = fdel(sgfx$)
4178  e = fdel(tmp$)
4180 endif
4182 l% = len(er$)
4184 if er < 0 then
4186  if co = -1 then
4188   co = fopen("con_")
4190   window#co; 250, 50 + (l% <> 0) * 10, (scr_xlim(#co) - 250) / 2, 40
4192   border#co; 2, 2: cls#co
4194  endif
4196  windsz#co; wsx%, wsy%, wox%, woy%
4198  woy% = (wsy% - 20 - (l% <> 0) * 10) / 2
4200  if len(fnm$) > l%: l% = len(fnm$)
4202  wox% = CP%(wsx%, l%)
4204  cursor#co; wox%, woy%
4206  bput#co; fnm$
4208  :
4210  if len(er$) then
4212   wox% = CP%(wsx%, len(er$)): woy% = woy% + 10
4214   cursor#co; wox%, woy%
4216   ink#co; 2: bput#co; er$
4218  endif
4220  :
4222  wox% = CP%(wsx%, len(errm$(er))): woy% = woy% + 10
4224  cursor#co; wox%, woy%
4226  ink#co; 7: bput#co; errm$(er)
4228  Burp: k$ = inkey$(#co; 150)
4230  if k$ <> '': pause#co
4232 endif
4234 quit er
4236 enddef Bye
4238 :
4240 def fn CP%(x%, l%)
4242 ret (x% - l% * 6) / 2
4244 enddef CP%
4246 :
4248 :
4250 rem + ------------------------------------------------------------------------ +
4252 rem |<                                Compact                                 >|
4254 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
4256 rem |                           Compact a file name                            |
4258 rem |                                                                          |
4260 rem | This not very elegant routine tries to compact a file name for visual    |
4262 rem | display in a variable environment. It tries to keep the (hopefully)      |
4264 rem | most relevant information visible as far as possible, without            |
4266 rem | exceeding the allowable length limit (w%)                                |
4268 rem + ------------------------------------------------------------------------ +
4270 rem | V0.01, pjw, 2018 Sep 23                                                  |
4272 rem + ------------------------------------------------------------------------ +
4274 :
4276 DEFine FuNction Compact$(fnm$, w%)
4278 loc i%, l%, dv$(6), dr$(36), nm$(36), ex$(6)
4280 IF w% <= 0: RETurn ''
4282 l% = LEN(fnm$)
4284 IF l% <= w%: RETurn fnm$
4286 IF l% <= 5 THEN
4288  IF w% <= 5: RETurn fnm$(1 TO w%)
4290  RETurn fnm$
4292 END IF
4294 dv$ = fnm$(1 TO 5)
4296 dr$ = fnm$(6 TO l%)
4298 l% = LEN(dr$)
4300 :
4302 FOR i% = l% TO l% - 4 STEP -1
4304  IF dr$(i%) INSTR '_.' THEN
4306   ex$ = dr$(i% TO l%)
4308   l% = i% - 1
4310   dr$ = dr$(1 TO l%)
4312   EXIT i%
4314  END IF
4316 END FOR i%
4318 :
4320 FOR i% = l%  TO 1 STEP -1
4322  IF dr$(i%) = '_' THEN
4324   nm$ = dr$(i% + 1 TO l%)
4326   dr$ = dr$(1 TO i%)
4328   EXIT i%
4330  END IF
4332 END FOR i%
4334 l% = LEN(nm$)
4336 :
4338 IF l% > w%: RETurn nm$(1 TO w% - 1) & '~'
4340 IF (l% + LEN(ex$)) >= w% THEN
4342  IF (w% - l%) > 1: RETurn nm$ & ex$(1 TO w% - l% - 1) & '~'
4344  RETurn nm$(1 TO w%)
4346 END IF
4348 l% = l% + LEN(ex$)
4350 :
4352 IF (l% + 6) > w%: RETurn '~' & nm$ & ex$
4354 :
4356 IF (w% - l% - 6) <= 0: RETurn dv$(1 TO 4) & '~' & nm$ & ex$
4358 RETurn dv$ & dr$(1 TO w% - l% - 6) & '~' & nm$ & ex$
4360 END DEFine Compact$
4362 :
4364 :
4366 rem + ------------------------------------------------------------------------ +
4368 rem |<                                 GetMem                                 >|
4370 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
4372 rem |            General purpose memory getter with error trapping             |
4374 rem |                                                                          |
4376 rem | Does not return to caller on error but bails out with farewell message.  |
4378 rem |                                                                          |
4380 rem | GLOBal er$ assumed to describe calling action; dyram = dynamic RAM       |
4382 rem | Dependency: MemOK                                                        |
4384 rem + ------------------------------------------------------------------------ +
4386 rem | V0.01, pjw, 2020 Nov 24                                                  |
4388 rem + ------------------------------------------------------------------------ +
4390 :
4392 def fn GetMem(mem)
4394 loc ad
4396 if MemOK(mem) = 0 then
4398  ad = alchp(mem)
4400  if ad > 0: ret ad
4402 endif
4404 :
4406 if ad = 0: ad = -3
4408 Bye ad, 'Out of memory: ' & er$
4410 ret -3:                         rem Never gets here..
4412 enddef GetMem
4414 :
4416 :
4418 rem + ------------------------------------------------------------------------ +
4420 rem |<                             MemOK/DynRAM                               >|
4422 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
4424 rem |                    Check if enough memory for graphic                    |
4426 rem |                                                                          |
4428 rem | The program needs to hold copy of a file in both memory and (possibly)   |
4430 rem | a dynamic ram disk. A check needs to be made in advance whether the      |
4432 rem | temporary disk is a dynamic ram disk or not. The result is given in      |
4434 rem | Reads GLOBal dyram. (This is not an exact science!)                      |
4436 rem + ------------------------------------------------------------------------ +
4438 rem | V0.01, pjw, 2018 Oct 01                                                  |
4440 rem + ------------------------------------------------------------------------ +
4442 :
4444 def fn MemOK(req)
4446 if dyram then
4448  if (free_mem + minfree) > (req + req): ret 0
4450 else
4452  if (free_mem + minfree) > req: ret 0
4454 endif
4456 ret -3:                                         rem Probably not enough room
4458 enddef MemOK
4460 :
4462 :
4464 def proc DynRAM(drv$)
4466 dyram = 0
4468 if ("ram" instr drv$) = 1 then
4470  if free_mem - (dmedium_free(\ drv$) * 512) < 0 then
4472   dyram = 1
4474  endif
4476 endif
4478 enddef DynRAM
4480 :
4482 :
4484 rem + ------------------------------------------------------------------------ +
4486 rem |<                                 Orphan                                 >|
4488 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
4490 rem |                   Checks whether "owner" alive or not                    |
4492 rem |                                                                          |
4494 rem | Since this job is not formally owned by the job that calls it, certain   |
4496 rem | functions that depend on such an owner must be disabled when the         |
4498 rem | owner is no longer there, such as a non-system palette, etc              |
4500 rem | Sets and reads GLOBal orphan:                                            |
4502 rem |    orfan = 0 => Owner lives                                              |
4504 rem |    orfan = 1 => this job is orphaned (ie owner no longer exists)         |
4506 rem + ------------------------------------------------------------------------ +
4508 rem | V0.01, pjw, 2018 Oct 13                                                  |
4510 rem + ------------------------------------------------------------------------ +
4512 :
4514 DEFine FuNction Orphan(jid)
4516 IF orfan: RETurn orfan
4518 IF JOB$(jid) = '' THEN
4520  orfan = 1
4522  if palette > 3: palette = 0: SetPal
4524 END IF
4526 RETurn orfan
4528 END DEFine Orphan
4530 :
4532 :
4534 rem + ------------------------------------------------------------------------ +
4536 rem |<                                ValidHex                                >|
4538 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
4540 rem |       Validate a hex string and return its decimal value or error        |
4542 rem |                                                                          |
4544 rem | Returns hex value in r.hx parameter!                                     |
4546 rem | A valid hex number is of the form                                        |
4548 rem |    [$]<hex digit>[<hex digit>] * 7                                       |
4550 rem | Where [] => optional, and hex digits are 0..9, A..F, a..f                |
4552 rem | The first non-hex charcter in an otherwise valid number terminates the   |
4554 rem | the number but does not invalidate it!                                   |
4556 rem | Numbers with more than 8 hex digits are truncated, but not invalidated!  |
4558 rem + ------------------------------------------------------------------------ +
4560 rem | V0.04, pjw, 2019 Dec 16, rewrite                                         |
4562 rem + ------------------------------------------------------------------------ +
4564 :
4566 DEFine FuNction ValidHex(hx$, r.hx)
4568 LOCal i%, d%, e%
4570 d% = (('$' INSTR hx$) = 1) + 1
4572 IF LEN(hx$) < d%: RETurn -15
4574 e% = d% + 7
4576 IF e% > LEN(hx$): e% = LEN(hx$)
4578 FOR i% = d% TO e%
4580  IF NOT hx$(i%) INSTR '0123456789ABCDEF': e% = i% - 1: EXIT i%
4582 END FOR i%
4584 IF e% < d%: RETurn -15
4586 r.hx = HEX(hx$(d% TO e%))
4588 RETurn 0
4590 END DEFine ValidHex
4592 :
4594 :
4596 rem + ------------------------------------------------------------------------ +
4598 rem |<                                GetName                                 >|
4600 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
4602 rem |               Check name and split into name and extension               |
4604 rem |                                                                          |
4606 rem | In this specialised version the file length and date is set in           |
4608 rem | GLOBal variables srcfln, srcdat                                          |
4610 rem |                                                                          |
4612 rem | Extension seperator may be . or _  but is not included                   |
4614 rem | dir$ always ends on underscore                                           |
4616 rem + ------------------------------------------------------------------------ +
4618 rem | V0.03, pjw, 2019 Aug 20                                                  |
4620 rem | V0.04, pjw, 2020 Apr 29, bug fix for short names                         |
4622 rem + ------------------------------------------------------------------------ +
4624 :
4626 def fn GetName(fnm$, r.dir$, r.nm$, r.xt$)
4628 loc i%, ch, l%
4630 ch = fop_in(fnm$): if ch < 0: ret ch
4632 srcdat = fupdt(#ch)
4634 srcfln = flen(#ch)
4636 r.nm$ = fname$(#ch): close#ch
4638 :
4640 ch = fop_dir(fnm$)
4642 l% = len(fname$(#ch)): close#ch
4644 :
4646 if len(r.nm$) = l%: ret -12
4648 r.nm$ = r.nm$(l% + 1 + (l% <> 0) to len(r.nm$))
4650 r.dir$ = fnm$(1 to len(fnm$) - len(r.nm$))
4652 :
4654 l% = len(r.nm$)
4656 if l% > 4 then
4658  for i% = l% to l% - 4 step -1
4660   if r.nm$(i%) instr '_.' then
4662    r.xt$ = r.nm$(i% + 1 to l%)
4664    r.nm$ = r.nm$(1 to i% - 1)
4666    ret 0
4668   endif
4670  end for i%
4672 endif
4674 r.xt$ = ''
4676 ret 0
4678 enddef GetName
4680 :
4682 :
4684 rem + ------------------------------------------------------------------------ +
4686 rem |<                                BSearch                                 >|
4688 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
4690 rem |                              Binary Search                               |
4692 rem |                                                                          |
4694 rem | Returns position if found, or -position where item should go. Thus it    |
4696 rem | can be used to add new, unique items to a list, in alphabetical order.   |
4698 rem | Strings only! Case sensitive!                                            |
4700 rem + ------------------------------------------------------------------------ +
4702 rem | V0.01, From TAOCP 6.2.1                                                  |
4704 rem + ------------------------------------------------------------------------ +
4706 :
4708 DEFine FuNction BSearch%(item$, Arr$)
4710 LOCal loop, u%, l%, i%
4712 l% = 0: u% = DIMN(Arr$)
4714 REPeat loop
4716  IF u% < l%: i% = -l%: EXIT loop
4718  i% = INT((l% + u%) / 2)
4720  IF item$ = Arr$(i%): EXIT loop
4722  IF item$ < Arr$(i%) THEN
4724   u% = i% - 1
4726  ELSE
4728   l% = i% + 1
4730  END IF
4732 END REPeat loop
4734 RETurn i%
4736 END DEFine BSearch%
4738 :
4740 :
4742 rem + ------------------------------------------------------------------------ +
4744 rem |<                             Set Pattern                                >|
4746 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
4748 rem |                     Sets up a pattern for a blob                         |
4750 rem |                                                                          |
4752 rem | Set GLOBal aval. This only need to be set once for blob.                 |
4754 rem |                                                                          |
4756 rem | This routine builds a RLE-compressed 16x1 pixel pattern sprite of the    |
4758 rem | current display mode. (Its ok if the mode of the pattern and blob are    |
4760 rem | different from each other - and also different from the display mode).   |
4762 rem + ------------------------------------------------------------------------ +
4764 rem | V0.01, pjw, 2018 Dec 26                                                  |
4766 rem | V0.03, pjw, 2019 Aug 19, Simplified for QV to only set avail             |
4768 rem | V0.03, pjw, 2020 Oct 11, SetHead -> SetHeader                            |
4770 rem + ------------------------------------------------------------------------ +
4772 :
4774 def proc SetPattern
4776 loc a
4778 SELect ON dmode%
4780  = 16: blb_ava = ALCHP(34): SetHeader blb_ava, 528, 1
4782  = 32: blb_ava = ALCHP(36): SetHeader blb_ava, 544, 2
4784  = 33: blb_ava = ALCHP(36): SetHeader blb_ava, 545, 2
4786  = REMAINDER : Bye -19
4788 END SELect
4790 enddef SetPattern
4792 :
4794 DEFine PROCedure SetHeader(ad, md%, sz%)
4796 POKE_W ad, md%, 64, 16, 1, 0, 0
4798 POKE_L ad + 12, 12, 0, 0, 0, sz% * 16
4800 POKE$  ad + 24, 'RLE' & sz%
4802 END DEFine SetHeader
4804 :
4806 rem + ------------------------------------------------------------------------ +
4808 rem |<                             Change Colour                              >|
4810 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
4812 rem |                        Alters a pattern's colour                         |
4814 rem |                                                                          |
4816 rem | Since WMan colours are "coded", ie the numbers may not be pure           |
4818 rem | representations of colour, we leave the hard work to WMan itself to      |
4820 rem | sort out, and merely reap the benefit by peeking the resulting native    |
4822 rem | colour from the CDB.                                                     |
4824 rem + ------------------------------------------------------------------------ +
4826 rem | V0.01, pjw, 2018 Dec 26                                                  |
4828 rem | V0.03, pjw, 2019 Aug 19, Simplified for QV: Only change avail colours    |
4830 rem + ------------------------------------------------------------------------ +
4832 :
4834 DEFine PROCedure CHG_COL(ch, wmi%)
4836 wm_ink#ch; wmi%: nat% = GETCOL%(#ch; 1)
4838 sel on dmode%: = 16: CHG_COL16 blb_ava, nat%: = 32, 33: CHG_COL3X blb_ava, nat%
4840 END DEFine CHG_COL
4842 :
4844 DEFine PROCedure CHG_COL3X(ad, c3x%)
4846 POKE ad + 32, 241, c3x% DIV b256%, c3x% MOD b256%, 0
4848 END DEFine CHG_COL3X
4850 :
4852 DEFine PROCedure CHG_COL16(ad, c16%)
4854 POKE ad + 32, 241, c16%
4856 END DEFine CHG_COL16
4858 :
4860 :
4862 rem + ------------------------------------------------------------------------ +
4864 rem |<                                  KMGb                                  >|
4866 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
4868 rem |                   Round size to some sensible display                    |
4870 rem |                                                                          |
4872 rem + ------------------------------------------------------------------------ +
4874 rem | V0.01, pjw, 2014 May 27                                                  |
4876 rem | V0.01, pjw, 2015 Apr 03, slightly improved..?                            |
4878 rem + ------------------------------------------------------------------------ +
4880 :
4882 DEFine FuNction KMGb$(b)
4884 LOCal n, m
4886 IF b < 10000: RETurn CDEC$(b, 8, 0) & '  b'
4888 n = b / 1024
4890 IF n < 1000: RETurn IDEC$(b / 10.24, 8, 2) & ' Kb'
4892 m = n / 1024
4894 IF m < 1000: RETurn IDEC$(n / 10.24, 8, 2) & ' Mb'
4896 n = m / 10.24
4898 RETurn IDEC$(n, 8, 2) & ' Gb'
4900 END DEFine KMGb$
4902 :
4904 :
4906 :
4908 rem + ************************************************************************ +
4910 rem *<                               Group Ops                                >*
4912 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
4914 rem *             Experimental operations on group of similar jobs             *
4916 rem *                                                                          *
4918 rem + ------------------------------------------------------------------------ +
4920 rem * V0.01, pjw, 2019 Jul 10+                                                 *
4922 rem + ************************************************************************ +
4924 :
4926 :
4928 rem + ------------------------------------------------------------------------ +
4930 rem |<                                  Tile                                  >|
4932 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
4934 rem | Resize all sorority windows to same size so as to fit display as tiles.  |
4936 rem |                                                                          |
4938 rem | To Do: Scaling. Swamps system on slow machines: Can this be fixed?       |
4940 rem | (See Broadcast.)                                                         |
4942 rem + ------------------------------------------------------------------------ +
4944 rem | V0.01, pjw, 2019 Jul 12                                                  |
4946 rem + ------------------------------------------------------------------------ +
4948 :
4950 def proc Tile
4952 loc i, nx, t%, sy%
4954 rem GLOBal ssx%, ssy%, N%, Nt%, nx%, ny%, tx%, ty%
4956 :
4958 N% = JobCount%(jnroot$, me%)
4960 if N% < 1: ret: rem Nothing to tile
4962 :
4964 rem     Work out no. tiles and size
4966 :
4968 rem     Find nearest perfect square
4970 N% = N% + 1: rem N% = 1..
4972 for i = N% to N% + N%
4974  nx = sqrt(i)
4976  if nx = int(nx): Nt% = i: exit i
4978 endfor i
4980 :
4982 rem     Adjust to optimal
4984 nx% = nx
4986 if nx * (nx - 1) >= N%: ny% = nx% - 1: else: ny% = nx%
4988 Nt% = nx% * ny%
4990 sy% = ssy% - 16: rem Leave room at the top
4992 if ssx% < sy%: t% = nx%: nx% = ny%: ny% = t%: rem Orientation
4994 :
4996 rem     Work out tile size
4998 tx% = int(ssx% / nx%)
5000 ty% = int(sy% / ny%)
5002 :
5004 wsx% = (tx% - wdx% - 4) && -4
5006 wsy% = (ty% - wdy% - 2) && -2
5008 :
5010 rem     My position
5012 rem me% = 0..N% - 1
5014 px% = tx% * (me% mod nx%)
5016 py% = ty% * (me% div nx%)
5018 :
5020 oox% = (px% + 3) && -2
5022 ooy% = py% + 16
5024 ptop#cw; jobid\ ''
5026 wmov#co; oox%, ooy%
5028 :
5030 filldis = 0:           rem No longer fills display
5032 scale% = 0:            rem New scaling allowed
5034 Limits
5036 mclear#co: Centre
5038 winx% = osx%: winy% = osy%
5040 mwlink#co\ aw_dis%, #cw
5042 :
5044 Broadcast ev_done%
5046 enddef Tile
5048 :
5050 :
5052 rem + ------------------------------------------------------------------------ +
5054 rem |<                                JobCount                                >|
5056 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
5058 rem |               Count number of jobs in sorority and find Me               |
5060 rem |                                                                          |
5062 rem + ------------------------------------------------------------------------ +
5064 rem | V0.01, pjw, 2019 Jul 10                                                  |
5066 rem + ------------------------------------------------------------------------ +
5068 :
5070 DEFine FuNction JobCount%(jnr$, r.me%)
5072 LOCal lp, n, c%
5074 n = 0: c% = -1
5076 REPeat lp
5078  n = NXJOB(n, 0): IF n = 0: EXIT lp
5080  IF (jnr$ INSTR JOB$(n)) = 1 THEN
5082   c% = c% + 1
5084   IF n = JOBID: r.me% = c%
5086  END IF
5088 END REPeat lp
5090 RETurn c%
5092 END DEFine JobCount%
5094 :
5096 :
5098 rem + ------------------------------------------------------------------------ +
5100 rem |<                               Broadcast                                >|
5102 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
5104 rem |             Signal command to all sister jobs in a sorority              |
5106 rem |                                                                          |
5108 rem | Wait a little for external job to complete operation                     |
5110 rem | (That doesnt seem to work, for some reason)                              |
5112 rem |                                                                          |
5114 rem | The Cascade command includes the job's position together with the        |
5116 rem | command, thus limiting the number of windows to 63                       |
5118 rem | Sleep and Kill dont act on Me                                            |
5120 rem | Some commands dont act on sleeping jobs. This is deliberate              |
5122 rem | GLOBal wait%                                                             |
5124 rem + ------------------------------------------------------------------------ +
5126 rem | V0.01, pjw, 2019 Jul 10+                                                 |
5128 rem + ------------------------------------------------------------------------ +
5130 :
5132 DEFine proc Broadcast(ev%)
5134 LOCal lp, n, me, c%
5136 n = 0: me = jobid: c% = -1
5138 REPeat lp
5140  n = NXJOB(n, 0): IF n = 0: EXIT lp
5142  IF (jnroot$ INSTR JOB$(n)) = 1 THEN
5144   c% = c% + 1
5146   sel on ev%
5148    = ev_quit%, ev_sleep%
5150      IF n = me: next lp: rem Dont do me yet!
5152      er = fsend_event(n, ev%)
5154    = ev_wake%, ev_done%, ev_tile%
5156      er = fsend_event(n, ev%)
5158    = ev_casc% to ev_all%
5160      if c% > 63: Burp: exit lp
5162      er = fsend_event(n, ev% + c%)
5164   endsel
5166   susjb me, 1
5168   er = wait_event(ev_done%, wait%)
5170  END IF
5172 END REPeat lp
5174 END DEFine Broadcast
5176 :
5178 :
5180 rem + ------------------------------------------------------------------------ +
5182 rem |<                                KillAll                                 >|
5184 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
5186 rem |        Send kill signal to all members of group, in reverse order        |
5188 rem |                            Then commit sepuku                            |
5190 rem |                                                                          |
5192 rem | Hmm, no guarantee that order in list is order of creation..              |
5194 rem + ------------------------------------------------------------------------ +
5196 rem | V0.01, pjw, 2019 Jul 16                                                  |
5198 rem + ------------------------------------------------------------------------ +
5200 :
5202 def proc KillAll
5204 LOCal i%, lp, ch, n, me, c%, n$(8)
5206 ch = fopen("history")
5208 n = 0: me = jobid: c% = -1
5210 REPeat lp
5212  n = NXJOB(n, 0): IF n = 0: EXIT lp
5214  IF (jnroot$ INSTR JOB$(n)) = 1 THEN
5216   c% = c% + 1
5218   if n <> me: print#ch; hex$(n, 32)
5220  endif
5222 endrep lp
5224 :
5226 for i% = 0 to c%
5228  input#ch; n$: n = hex(n$)
5230  er = fsend_event(n, ev_quit%): rem susjb me, 1
5232 END for i%
5234 close#ch: Bye 0, ''
5236 enddef KillAll
5238 :
5240 rem + ------------------------------------------------------------------------ +
5242 rem |<                                Cascade                                 >|
5244 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
5246 rem |      (Incomplete) routine to cascade all sister jobs in a sorority       |
5248 rem |                                                                          |
5250 rem | Does not resize windows, so Wman will place them as best it can. The     |
5252 rem | job from which the command was issued, ends up on top.                   |
5254 rem | Only a single cascade is implemented (for now), as window siszes are not |
5256 rem | known outside their job. This may be improved later..                    |
5258 rem + ------------------------------------------------------------------------ +
5260 rem | V0.01, pjw, 2019 Jul 10                                                  |
5262 rem + ------------------------------------------------------------------------ +
5264 :
5266 def proc Cascade(me%)
5268 loc m%
5270 m% = me% && (ev_casc% - 1)
5272 oox% = m% * 10: ooy% = (m% + 1) * 20
5274 ptop#cw; jobid\ ''
5276 wmov#co; oox%, ooy%
5278 mwlink#co\ aw_dis%, #cw
5280 Broadcast ev_done%
5282 enddef Cascade
5284 :
5286 :
5288 def proc WakeUp
5290 LOCal lp, n, a
5292 n = 0
5294 REPeat lp
5296  n = nxjob(n, 0): if n = 0: exit lp
5298  if (jnroot$ instr job$(n)) = 1 then
5300   a = nxjob(n, 0)
5302   if a then
5304    if asleep$ instr job$(a): rjob a, 0
5306   endif
5308   ptop#co; n
5310  endif
5312 endrep lp
5314 enddef WakeUp
5316 :
5318 :
5320 def proc Sleep
5322 loc n
5324 n = nxjob(jobid, 0)
5326 if n then
5328  if not asleep$ instr job$(n): ptop#co; jobid: exep btsleep$
5330 else
5332  ptop#co; jobid: exep btsleep$
5334 endif
5336 Broadcast ev_done%
5338 enddef Sleep
5340 :
5342 :
5344 :
5346 rem + ************************************************************************ +
5348 rem *<                               Functions                                >*
5350 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
5352 rem *                             Menu, Info, etc                              *
5354 rem *                                                                          *
5356 rem + ------------------------------------------------------------------------ +
5358 rem * V0.01, pjw, 2019 Aug ++                                                  *
5360 rem + ************************************************************************ +
5362 :
5364 :
5366 rem + ------------------------------------------------------------------------ +
5368 rem |<                                F2 Menu                                 >|
5370 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
5372 rem |                    Draws and reads the actual F2 menu                    |
5374 rem |                                                                          |
5376 rem | GLOBal ev_rpt%, ev%, ooy%, + caller's LOCals x%, y%, k%, mc%             |
5378 rem + ------------------------------------------------------------------------ +
5380 rem | V0.01, pjw, 2019 Nov 17                                                  |
5382 rem + ------------------------------------------------------------------------ +
5384 :
5386 def proc F2Menu
5388 loc mlp, ch, xs%, ys%
5390 xs% = peek_w(SP_TRAN + 4)
5392 ys% = peek_w(SP_TRAN + 6)
5394 :
5396 ch = fopen('con')
5398 x% = oox% + (wsx% - xs%) / 2
5400 y% = ooy% + (wsy% - ys%) / 2
5402 mdraw#ch; MN_MENU, x%, y%, xs%, ys%
5404 blobw#ch; 0, 0, SP_TRAN, blb_ava
5406 v% = 17
5408 x% = x% + menx% div 2: y% = y% + 16
5410 rdpt#ch; irt%, x%, y%
5412 :
5414 rep mlp
5416  k% = rpt%(#ch; v%! ev_rpt%, x%, y%, -1)
5418  ev% = ev_rpt% div b256%: if ev%: exit mlp
5420  k% = v% div b256%
5422  sel on k%
5424   = 0, 27: k% = 0: exit mlp
5426   = 1, 2
5428     sel on x%
5430      =  0 to 20: rem Col 1
5432       sel on y%
5434        =  0 to 20 : k% = 53
5436        = 35 to 55 : k% = 49
5438        = 65 to ys%: k% = 55
5440        = remainder: next mlp
5442       endsel
5444       exit mlp
5446      = 35 to 55: rem Col 2
5448       sel on y%
5450        =  0 to 20 : k% = 48
5452        = 65 to ys%: k% = 50
5454        = remainder: next mlp
5456       endsel
5458       exit mlp
5460      = 65 to xs%: rem Col 3
5462       sel on y%
5464        =  0 to 20 : k% = 52
5466        = 35 to 55 : k% = 51
5468        = 65 to ys%: k% = 54
5470        = remainder: next mlp
5472       endsel
5474       exit mlp
5476     endsel
5478   = 0 to 55: exit mlp
5480   = remainder: if k% < 0: k% = k% + b256%
5482     exit mlp
5484  endsel
5486 endrep mlp
5488 mclear#ch
5490 close#ch
5492 :
5494 if ev%: DoEvent: ret
5496 if k% > 0: Transform k% + 96
5498 x% = oox% + wsx% / 2: y% = ooy% + wsy% / 2
5500 rdpt#co; irt%, x%, y%
5502 enddef F2Menu
5504 :
5506 :
5508 rem + ------------------------------------------------------------------------ +
5510 rem |<                                F3 Menu                                 >|
5512 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
5514 rem |                    Draws and reads the actual F3 menu                    |
5516 rem |                                                                          |
5518 rem | GLOBal ev_rpt%, ev%, ooy%, + caller's LOCals x%, y%, k%, mc%             |
5520 rem + ------------------------------------------------------------------------ +
5522 rem | V0.01, pjw, 2019 Aug 25                                                  |
5524 rem + ------------------------------------------------------------------------ +
5526 :
5528 def proc F3Menu
5530 loc mlp, ch, xs%, ys%
5532 xs% = peek_w(SP_MENU + 4)
5534 ys% = peek_w(SP_MENU + 6)
5536 :
5538 ch = fopen('con')
5540 x% = oox% + (wsx% - xs%) / 2
5542 y% = ooy% + 20
5544 mdraw#ch; MN_MENU, x%, y%, xs%, ys%
5546 blobw#ch; 0, 0, SP_MENU, blb_ava
5548 v% = 17
5550 x% = x% + menx% div 2: y% = y% + 16
5552 rdpt#ch; irt%, x%, y%
5554 :
5556 rep mlp
5558  k% = rpt%(#ch; v%! ev_rpt%, x%, y%, -1)
5560  ev% = ev_rpt% div b256%: if ev%: exit mlp
5562  k% = v% div b256%
5564  sel on k%
5566   = 0, 27: k% = 0: exit mlp
5568   = 1, 2
5570     sel on x%
5572      =  4 to 19: k% =  84: exit mlp
5574      = 24 to 39: k% =  67: exit mlp
5576      = 44 to 53: k% =  73: exit mlp
5578      = 59 to 74: if keyrow(7) = 2: k% =  82: else: k% =  83: endif: exit mlp
5580      = 79 to 90: if keyrow(7) = 2: k% = 114: else: k% = 115: endif: exit mlp
5582     endsel
5584   = remainder: if k% < 0: k% = k% + b256%
5586     exit mlp
5588  endsel
5590 endrep mlp
5592 mclear#ch
5594 close#ch
5596 :
5598 if ev%: DoEvent: ret
5600 if k% > 0: Keys k%
5602 x% = oox% + wsx% / 2: y% = ooy% + 24
5604 rdpt#co; irt%, x%, y%
5606 enddef F3Menu
5608 :
5610 :
5612 rem + ------------------------------------------------------------------------ +
5614 rem |<                               SavePic/c                                >|
5616 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
5618 rem | Save the current display in the current dispmode (ie a screen dump) as a |
5620 rem | Pic file. Uses the current filename sans the extension and adds the      |
5622 rem | pic extension. If the file already exists it adds an increment number    |
5624 rem | and tries again up to ten times (none, 0..9)                             |
5626 rem |                                                                          |
5628 rem | Uses PHGTK extension FPIC_SAVE                                           |
5630 rem | Reads GLOBal #cw, dir$, nm$, xt$, wox%, woy%, dsx%, dsy%                 |
5632 rem + ------------------------------------------------------------------------ +
5634 rem | V0.02, pjw, 2019 Aug 20                                                  |
5636 rem | V0.03, pjw, 2020 May 10, SavePac adds compression                        |
5638 rem + ------------------------------------------------------------------------ +
5640 :
5642 def fn SavePic(part)
5644 loc fnm$(41)
5646 fnm$ = SaveFnm$(dir$, nm$, '_pic')
5648 if er = 0 then
5650  if part then
5652   er = fpic_save(#cw; fnm$, wox%, woy%, dsx%, dsy%)
5654  else
5656   copy gfx$ to fnm$
5658  endif
5660 endif
5662 ret er
5664 enddef SavePic
5666 :
5668 :
5670 def fn SavePac(part)
5672 loc i%, pcc, fl, sz, rle%, fnm$(41)
5674 :
5676 sel on gmode%
5678  = 16: rle% = 1
5680  = 32, 33: rle% = 2
5682  = remainder : return -19: rem Should never happen..
5684 endsel
5686 :
5688 if part then
5690  rem Part save
5692  adr = wsain(#cw; dsx%, dsy%): if adr <= 0: Bye -3, 'Saving part PAC'
5694  wsasv#cw; adr, dsx%, dsy%, wox%, woy%
5696  rem For some reason wsain increases llen!
5698  fl = 14 + peek_w(adr + 6) * dsy%
5700 else
5702  rem Save whole
5704  adr = pic
5706  fl = 14 + llen% * gsy%
5708 endif
5710 :
5712 er$ = 'Saving'
5714 pcc = GetMem(fl)
5716 sz = enrle(adr + 10, pcc + 14, fl - 14, rle%)
5718 if sz = -5 then
5720  rechp pcc
5722  if part: rechp adr:    rem Release temporary buffer
5724  ret SavePic(part):     rem Not compressable: Normal save
5726 endif
5728 :
5730 pokes$ pcc, 'RLE' & rle%
5732 pokes$ pcc + 4, peek$(adr, 10)
5734 :
5736 fnm$ = SaveFnm$(dir$, nm$, '_pac')
5738 if er = 0: sbytes fnm$, pcc, sz + 14
5740 rechp pcc
5742 if part: rechp adr:     rem Release temporary buffer
5744 ret er
5746 enddef SavePac
5748 :
5750 :
5752 def fn SaveFnm$(d$, n$, x$)
5754 loc i%
5756 rem GLOBal er
5758 er = ftest(d$ & n$ & x$)
5760 if er = -7: er = 0: ret d$ & n$ & x$
5762 if len(d$ & n$ & x$) > 40: ret -12
5764 for i% = 0 to 9
5766  er = ftest(d$ & n$ & i% & x$)
5768  if er = -7: exit i%
5770 endfor i%
5772 if er = -7: er = 0: ret d$ & n$ & i% & x$
5774 if er = 0: er = -8
5776 ret ''
5778 enddef SaveFnm$
5780 :
5782 :
5784 rem + ------------------------------------------------------------------------ +
5786 rem |<                                  Info                                  >|
5788 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
5790 rem |                            Info on image file                            |
5792 rem |                                                                          |
5794 rem + ------------------------------------------------------------------------ +
5796 rem | V0.01, pjw, 2019 Aug 17                                                  |
5798 rem | V0.02, pjw, 2020 Dec 14, Edit headless dumps                             |
5800 rem + ------------------------------------------------------------------------ +
5802 :
5804 def proc Info
5806 loc ml, ci, nr%, k, k%, v%, v, st%, dt$(20)
5808 :
5810 rem if ogsx% <> gsx% or ogsy% <> gsy%: nr% = 5: else nr% = 4
5812 if scale%: nr% = 5: else nr% = 4
5814 nr% = nr% * 11
5816 :
5818 if wsx% < 200 or wsy% < (nr% + 28): Burp: ret
5820 :
5822 ci = fopen("con")
5824 mdraw#ci; MN_SUB, oox% + (wsx% - 180) / 2, ooy% + 40, 180, nr% + 22
5826 mitem#ci; -3, 0, '' & gsx%
5828 mitem#ci; -4, 0, '' & gsy%
5830 sel on typ%
5832  = gt_unk% to gt_sc64%, gt_pac%
5834    mitem#ci; -2, 0, '' & gmd%
5836  = remainder
5838    mitem#ci; -2, 0, ''
5840 endsel
5842 :
5844 sel on typ%
5846  = gt_pic% to gt_spr%, gt_jpg% to 99
5848     k% = mstat%(#ci; 0, -1\ 0)
5850     k% = mstat%(#ci; -1, 0)
5852  = remainder
5854    if scale% then
5856     k% = mstat%(#ci; 0, -1\ 0)
5858     k% = mstat%(#ci; -1, 0)
5860    endif
5862 endsel
5864 :
5866 mdraw#ci
5868 Title#ci; 'Info'
5870 mwindow#ci\ 1! 0
5872 wm_paper#ci; sp_infwinbg%
5874 wm_ink#ci; sp_infwinfg%
5876 dt$ = date$(srcdat): dt$ = dt$(1 to 17): rem Qlib cant: date$(srcdat)(1 to 17)
5878 cursor#ci; 66,  0: bput#ci; type$
5880 cursor#ci; 66, 11: bput#ci; dt$
5882 cursor#ci; 66, 22: bput#ci; detab$(KMGb$(srcfln))
5884 :
5886 if nr% = 55 then
5888  cursor#ci; 0, 45
5890  wm_ink#ci; sp_infwinmg%: print#ci; 'Orig size: ';
5892  wm_ink#ci; sp_infwinfg%: print#ci; idec$(ogsx%, 6, 0)! 'x'! idec$(ogsy%, 6, 0);
5894 endif
5896 :
5898 eve% = wait_event(255, 0):      rem Clear any pending events
5900 eve% = ev_all% * b256%: ev% = 0
5902 st% = 0
5904 rep ml
5906  k = mcallt(#ci\ eve%, -1)
5908  k% = mkey%(#ci)
5910  sel on k
5912   = -1280: rem Events
5914      ev% = eve% div b256%
5916      if ev%: exit ml
5918   = -1032: wmov#ci
5920   = -1: exit ml
5922   = -2: rem Mode
5924         if k% = 1: st% = mstat%(#ci; k, mstat%(#ci; k)): next ml
5926         v% = Inp%(k, gmd%)
5928         if v% <> gmd% then
5930          st% = 1
5932          sel on v%
5934           = 0,4,8,16,32,33,64: Ping
5936             if v% = 4: gmd% = 0: else: gmd% = v%
5938             if mstat%(#ci; -3) = 0: gsx% = -1
5940             if mstat%(#ci; -4) = 0: gsy% = -1
5942             sel on gmd%
5944              =  0: typ% = gt_sc0%
5946              =  8: typ% = gt_sc8%
5948              = 16: typ% = gt_sc16%
5950              = 32: typ% = gt_sc32%
5952              = 33: typ% = gt_sc33%
5954              = 64: typ% = gt_sc64%: rem Not implemented throughout..
5956             endsel
5958             ReDoGfx: ret
5960           = remainder: Burp: k% = mstat%(#ci; k, 0)
5962          endsel
5964         endif
5966   = -3: rem X
5968         if k% = 1: st% = mstat%(#ci; k, mstat%(#ci; k)): next ml
5970         v% = Inp%(k, gsx%)
5972         if v% <> gsx% then
5974          st% = 1
5976          v = srcfln / v%
5978          if int(v) = v then
5980           Ping
5982           gsx% = v%
5984           if mstat%(#ci; -2) = 0: gmd% = -1
5986           if mstat%(#ci; -4) = 0: gsy% = -1
5988           ReDoGfx: ret
5990          else
5992           Burp
5994          endif
5996         endif
5998   = -4: rem Y
6000         if k% = 1: st% = mstat%(#ci; k, mstat%(#ci; k)): next ml
6002         v% = Inp%(k, gsy%)
6004         if v% <> gsy% then
6006          st% = 1
6008          v = srcfln / v%
6010          if int(v) = v then
6012           Ping
6014           gsy% = v%
6016           if mstat%(#ci; -2) = 0: gmd% = -1
6018           if mstat%(#ci; -3) = 0: gsx% = -1
6020           ReDoGfx: ret
6022          else
6024           Burp
6026          endif
6028         endif
6030   =  1: rem Title AW
6032         sel on k%
6034          = 1: wmov#ci: mwindow#ci\ 1! 0
6036          = 2: exit ml
6038         endsel
6040  endsel
6042 endrep ml
6044 mclear#ci: close#ci
6046 if ev%: DoEvent
6048 enddef Info
6050 :
6052 :
6054 def fn Inp%(it%, v)
6056 loc lp, v$(4)
6058 v$ = v
6060 mwindow#ci, it%
6062 rep lp
6064  minput#ci; v$\ 0
6066  if mkey%(#ci) = 27: ret v
6068  if valid%(3, v$): exit lp
6070  Burp
6072 endrep lp
6074 ret v$
6076 enddef Inp%
6078 :
6080 :
6082 def proc ReDoGfx
6084 rem mwindow#ci; 0: cls#ci: print#ci; gmd%, gsx%, gsy%: pause#ci
6086 mclear#ci: close#ci
6088 rechp pic
6090 er = GetDump: if er < 0: Bye er, er$
6092 rem print#ci; typ%, gmd%, gsx%, gsy%: pause#ci: quit
6094 er = Convert: if er < 0: Bye er, er$
6096 LoadPic gfx$
6098 Centre
6100 enddef ReDoGfx
6102 :
6104 :
6106 def proc Ping: beep 2000,   2: enddef Ping
6108 def proc Burp: beep 2000, 200: enddef Burp
6110 :
6112 :
6114 rem + ------------------------------------------------------------------------ +
6116 rem |<                                RezUnkn                                 >|
6118 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
6120 rem |                            Resolution Unknown                            |
6122 rem |                                                                          |
6124 rem | Last resort to guess at metrics based on file size                       |
6126 rem | "Assumes" gfx is of current mode to avoid conversion (since one guess is |
6128 rem | as unlikely as another..)                                                |
6130 rem |                                                                          |
6132 rem | Updates parameters                                                       |
6134 rem + ------------------------------------------------------------------------ +
6136 rem | V0.02, pjw, 2020 Dec 08                                                  |
6138 rem + ------------------------------------------------------------------------ +
6140 :
6142 DEFine FuNction RezUnkn(fl, x%, y%, m%)
6144 loc tx, ty, t
6146 tx = MaxSqu(fl):                rem Estimate a possible x
6148 if tx < 3: return 0:            rem Not a valid gfx file?
6150 :
6152 sel on dmode%
6154  = 0, 8
6156    t = fl / 2
6158    if int(t) <> t: return 0:    rem Not a QL mode gfx..
6160    t = fl * 4
6162    tx = MaxSqu(t):              rem Estimate a possible x
6164    if tx < 3: return 0:         rem Not a valid gfx file?
6166  = 16
6168    t = fl
6170    tx = MaxSqu(fl):             rem Estimate a possible x
6172    if tx < 3: return 0:         rem Not a valid gfx file?
6174  = 32, 33
6176    t = fl / 2
6178    if int(t) <> t: return 0:    rem Not a QL mode gfx..
6180    tx = MaxSqu(t):              rem Estimate a possible x
6182    if tx < 3: return 0:         rem Not a valid gfx file?
6184 endsel
6186 ty = t / tx
6188 if int(ty) <> ty: ret 0
6190 x% = tx: y% = ty: m% = dmode%
6192 ret 1
6194 END DEFine RezUnkn
6196 :
6198 :
6200 rem + ------------------------------------------------------------------------ +
6202 rem |<                                 MaxSqu                                 >|
6204 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
6206 rem |          Attempts to find a sane X-dimension for a screen dump           |
6208 rem |                                                                          |
6210 rem | Given file size (n), return an integer value of X, somewhere in the range|
6212 rem | of SQRT(n). Then N / X = Y, all integer. If it fails to find such a      |
6214 rem | value it returns 0.                                                      |
6216 rem |                                                                          |
6218 rem | Im no mathematician! If anyone knows a better way of achieving this      |
6220 rem | please let me know!                                                      |
6222 rem + ------------------------------------------------------------------------ +
6224 rem | V0.01, pjw, 2020 Dec 08                                                  |
6226 rem + ------------------------------------------------------------------------ +
6228 :
6230 DEFine FuNction MaxSqu(n)
6232 IF n < 4: RETurn 0:             rem Dont even bovver
6234 x = INT(SQRT(n))
6236 FOR y = INT(x / 2) TO x + x
6238  x = n / y
6240  IF x = INT(x): RETurn x
6242 END FOR y
6244 RETurn 0:                       rem Non found
6246 END DEFine MaxSqu
6248 :
6250 :
6252 rem + ------------------------------------------------------------------------ +
6254 rem |<                                Spr2Pic                                 >|
6256 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
6258 rem |                        Convert sprite to PIC/PAC                         |
6260 rem |                                                                          |
6262 rem | overw - 1 => unconditional overwrite, 0 => error if file already exists! |
6264 rem |                                                                          |
6266 rem | If sprite pattern compressed, then -> PAC, otherwise -> PIC              |
6268 rem | Mask/Alpha ignored! Modes 0/4, 8, 16, 32, 33, 64. No mode conversion!    |
6270 rem | Only converts first sprite found!                                        |
6272 rem | Complex sprites may cause too much data to be saved!                     |
6274 rem |                                                                          |
6276 rem | Dependencies: LDATA. Can easily be changed. PEEK$/POKE$ => SMSQ/E        |
6278 rem + ------------------------------------------------------------------------ +
6280 rem | V0.03, pjw, 2020 May 15, universal                                       |
6282 rem | V0.04, pjw, 2020 May 19, uni-buffer                                      |
6284 rem | V0.04, pjw, 2023 Apr 25, modified for QV                                 |
6286 rem + ------------------------------------------------------------------------ +
6288 :
6290 def fn Spr2Pic
6292 loc spr, tp%, ct%, x%, y%, pic
6294 loc ll%, bpp, ofs
6296 :
6298 rem     Load sprite and read header
6300 srcfnl = 0
6302 adr   = LDATA(fnm$, srcfnl): rem Reserves space, loads data; size returned in srcfnl
6304 if adr < 0: return adr:                 rem File error
6306 tp%   = peek  (adr + 0)
6308 gmd%  = peek  (adr + 1)
6310 ct%   = peek  (adr + 3)
6312 x%    = peek_w(adr + 4)
6314 y%    = peek_w(adr + 6)
6316 :
6318 if tp% = 0: rechp adr: return -19:      rem We dont do system sprites!
6320 :
6322 rem     Find bytes per pixel (bpp)
6324 sel on gmd%
6326  = 0:           bpp = 0.25
6328  = 1: gmd% = 8: bpp = 0.25: rem SPR mode 1 = PIC mode 8
6330  = 16:          bpp = 1
6332  = 32, 33:      bpp = 2
6334  = 64:          bpp = 4
6336  = remainder:   ret -19
6338 endsel
6340 :
6342 rem     Work out line length
6344 rem SPR line lengths are multiples of 4
6346 ll% = 4 * int((bpp * x% + 3) / 4)
6348 :
6350 rem     Pattern compressed?
6352 if ct% && 64 then
6354  rem Yes => PAC
6356  ofs = 4
6358  srcfnl = EstSze - 8: rem Estimate size of data
6360 else
6362  rem No => PIC
6364  ofs = 0
6366  srcfnl = ll% * y%
6368 endif
6370 :
6372 rem     Find offset in SPR to place PIC/PAC header
6374 pat = peek_l(adr + 12) + 12
6376 if ofs then
6378  pic = adr + pat - 6
6380  POKE$ pic, PEEK$(adr + pat, 4): rem Extra header info for PAC
6382 else
6384  pic = adr + pat - 10
6386 endif
6388 :
6390 rem     Set remaining PIC header
6392 poke_w pic + ofs + 0, $4afc
6394 poke_w pic + ofs + 2, x%, y%, ll%
6396 poke   pic + ofs + 8, gmd%
6398 gmode% = gmd%
6400 :
6402 sbytes_o gfx$, pic, srcfln + 10 + ofs
6404 rechp adr
6406 :
6408 if ofs = 4 then
6410  srcfln = 0
6412  adr = ldata(gfx$, srcfln)
6414  ret RLE2Md
6416 else
6418  er$ = 'Converting PIC'
6420  sel on gmode%
6422   = 0, 4, 8
6424     er = fpic_ql(gfx$, gfx$, dmode%)
6426   = 16, 32, 33, 64
6428     srcfln = 0
6430     adr = ldata(gfx$, srcfln)
6432     er = CVtoNAT(adr, srcfln)
6434     rechp adr
6436   = remainder: er = -19
6438  endsel
6440 endif
6442 ret er
6444 enddef Spr2Pic
6446 :
6448 :
6450 rem + ------------------------------------------------------------------------ +
6452 rem |<                                 EstSze                                 >|
6454 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
6456 rem |                 Estimate size of compressed sprite data                  |
6458 rem |                                                                          |
6460 rem | This is not fool proof! It just covers some automated sprite             |
6462 rem | generation utilites' common formats.                                     |
6464 rem + ------------------------------------------------------------------------ +
6466 rem | V0.01, pjw, 2020 May 15                                                  |
6468 rem + ------------------------------------------------------------------------ +
6470 :
6472 def fn EstSze
6474 loc msk, pat
6476 pat = peek_l(adr + 12)
6478 msk = peek_l(adr + 16)
6480 if pat > msk then
6482  rem Assume pattern data takes up rest of file
6484  ret srcfln - pat - 12: rem srcfln - (pat - 12) - 24
6486 else
6488  rem Assume data is difference
6490  ret msk - pat + 4: rem (msk - 8) - (pat - 12)
6492 endif
6494 enddef EstSze
6496 :
6498 :
6500 def fn Mpeg(nm$, md%)
6502 loc w%, h%
6504 :
6506 er = Jdims(nm$, w%, h%): if er < 0: ret er
6508 sel on md%
6510  = 0, 4, 8: ret (w% * h% / 4) + 10
6512  = 16: ret w% * h% + 10
6514  = 32, 33: ret 2 * w% * h% + 10
6516  = 64: ret 4 * w% * h% + 10
6518 endsel
6520 ret -15
6522 enddef Mpeg
6524 :
6526 :
6528 rem + ------------------------------------------------------------------------ +
6530 rem |<                                 Jdims                                  >|
6532 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
6534 rem |                   Get dimensions of a JPEG image file                    |
6536 rem |                                                                          |
6538 rem | Simple (and possibly unsafe!) method of getting JPEG x/y                 |
6540 rem | No guarantee that x/y is not y/x! (There must be an orientation setting  |
6542 rem | somewhere..)                                                             |
6544 rem + ------------------------------------------------------------------------ +
6546 rem | V0.01, pjw, 2023 Apr 29                                                  |
6548 rem + ------------------------------------------------------------------------ +
6550 :
6552 def fn Jdims(fnm$, r.w%, r.h%)
6554 loc ch, lp, il, w%, b%, pos
6556 ch = fop_in(fnm$): if ch < 0: ret ch
6558 if flen(#ch) < 1024: close#ch: ret -12
6560 wget#ch; w%: if w% <> -40: close#ch: ret -12:            rem $FFD8 - JPEG ID
6562 :
6564 er = 0
6566 rep lp
6568  if eof(#ch): pos = -10: exit lp:                       rem No EOI marker found
6570  bget#ch; b%: if b% <> 255: next lp:                    rem Looking for marker
6572  bget#ch; b%:                                           rem This is a code (or filler)
6574  sel on b%
6576   = 217: pos = -1: exit lp:                             rem $D9 = EOI: Dims not found
6578   = 224 to 239:                                         rem Special blocks
6580     pos = fpos(#ch):                                    rem Register where (for debugging)
6582     wget#ch; w%:                                        rem (Normally) length to skip
6584     if w% <= 0 then
6586      rem Some blocks dont have "normal" structures, ie length.., so skip to end
6588      rep il
6590       if eof(#ch): pos = -10: exit lp:                  rem An error
6592       bget#ch; b%: if b% <> 255: next il
6594       bget#ch; b%: if b% <> 217: next il:               rem Looking for EOI
6596       exit il:                                          rem  inside special block
6598      endrep il
6600     else
6602      get#ch\ pos + w%:                                  rem Skip past normal block
6604     endif
6606   = 192:                                                rem $C0
6608     pos = FPOS(#ch) - 2
6610     wget#ch; w%: bget#ch; b%:                           rem Skip past this
6612     wget#ch; r.h%, r.w%:                                rem Got what we came for!
6614     exit lp
6616  endsel
6618 endrep lp
6620 close#ch: ret pos
6622 enddef Jdims
6624 :
6626 :
