* QL WORLD DIY TOOLKIT - MSEARCH flexible memory scanner
* Version 0.8, Copyright 1993,1994 Simon N Goodwin.
* Updated to match [ \ ] ^ _ ` even at start of string
*
* V0.9, pjw, 2023 May 29, Uses table for case translation
*                         Code split up and made Qmac and PTOOL compatible

        section code

        include dev8_keys_sbasic
        include dev8_keys_qlv

        xdef xsearch

        xref tab_accent
        xref lin2flt

*
* address = XSEARCH ( address, length , | ! string$ )
*
* where , => case agnostic and ! => case conscious (can twice as fast)
*

xsearch
           lea.l    3*8(a3),a0        Three parameters are required
           cmpa.l   a0,a5
           bne      bad_param         Otherwise report 'bad parameter'

           move.w   8(a6,a3.l),d4     get separator info

           move.l   sb_arthp(a6),d7   Save BV.RIP, maths stack pointer
           subq.l   #8,a5             Conceal the last parameter, for now
           movea.w  sb.gtlin,a0       Fetch the CA.GTLIN vector
           jsr      (a0)              Try to get two long integers
           bne      bad_exit

           movea.l  0(a1,a6.l),a4  a4 = address parameter
           move.l   4(a1,a6.l),d5  d5 = search length parameter
           ble      bad_param         This must be greater than zero!

           move.l   a5,a3             Prior end is new start
           addq.l   #8,a5             Retrieve last parameter

           andi.w   #$00f0,d4         strip unwanted info
           lsr.w    #6,d4          d4 = 1 is sep exclamation mark!

           movea.w  sb.gtstr,a2       Fetch the CA.GTSTR vector
           jsr      (a2)              Get the string onto the RI stack
           bne.s    bad_exit

           move.w   0(a1,a6.l),d2  d2 = string length
           ble.s    bad_param         Reject null or inplausible pattern (>32K)

           ext.l    d2
           move.l   d5,d3             Copy the target length for checking
           sub.l    d2,d3          d3 counts possible match positions
           bcs.s    bad_search        Pattern is longer than target!

           lea.l    tab_accent,a5  a5 -> character translation table
           movea.l  a4,a0          a0 -> to memory to be scanned
           moveq    #0,d1             Clear register for byte
           move.b   2(a1,a6.l),d1     Pick up the first character
           move.b   d1,d5          d5 = copy of first unadulterated byte
           move.b   (a5,d1.w),d1   d1 = character (lowevrcased)

           subq.l   #2,d2          d2 = remaining pattern length for DBRA
           bmi      scan_just1

           lea.l    3(a1),a3          Point A3 at the second character

           tst.w    d4
           bne.s    multiscan

           move.b   d1,d5          d5 = copy of first (lowercased) byte
           move.w   d2,d0             Copy count for pattern case conversion

case_lock
           move.b   3(a1,a6.l),d1     Pick up each pattern byte after first
           move.b   (a5,d1.w),3(a1,a6.l) Store lowercased code
           addq.l   #1,a1             Advance to the next
           dbra     d0,case_lock      Scan all the rest of the pattern

*
* Case-independent scanner for patterns of more than one byte
*
           subq.l   #1,a3             Check entire string if quick test OK
           move.b   d5,(a3,a6.l)      Store corrected first byte
           addq.w   #1,d2             Add one to length for later checks

           lea.l    slow_scan,a4      Record top of loop for later retries

slow_scan
           move.b   (a0)+,d1
           cmp.b    (a5,d1.w),d5

slow_retry
           dbeq     d3,slow_scan      Loop till first byte seems to match
           bne.s    searched          No match yet; scan complete?

           movea.l  a3,a1          a1 -> the pattern
           lea.l    -1(a0),a2      a2 -> the possible match
           move.w   d2,d4          d4 = Temporary count variable

check_rest
           move.b   (a2)+,d1
           move.b   (a5,d1.w),d1
           cmp.b    (a1,a6.l),d1
           addq.l   #1,a1             Advance through the pattern
           dbne     d4,check_rest     Check all characters after the first

           bne.s    slow_retry        Mismatch, start again
           bra.s    found

*
bad_param
           moveq     #-15,d0          BAD PARAMETER error code
bad_exit
           rts
*
bad_search
           moveq     #0,d1            Return zero, pattern not found
           bra.s     end_search

*
* Exact scan for patterns of more than one byte
*

multiscan
           lea.l    scanner,a4        Record top of loop for later retries
scanner
           cmp.b    (a0)+,d5          Check for the first byte
retry
           dbeq     d3,scanner
           bne.s    searched          No match yet; scan complete?

           movea.l  a3,a1             A1 points to the rest of the text
           movea.l  a0,a2             Save point reached for retry later
           move.w   d2,d4             Temporary count variable for the rest
scan_rest
           move.b   (a2)+,d0
           cmp.b    0(a1,a6.l),d0
           addq.l   #1,a1             Advance through the pattern
           dbne     d4,scan_rest      Check all characters after the first
           bne.s    retry             Mismatch, start again

found
           move.l   a0,d1             Eureka!
           subq.l   #1,d1             Compensate for increment in SCANNER

end_search subq.l   #6,d7             Make room for a floating-point value
           move.l   d7,sb_arthp(a6)   Tidy the BV.RIP maths stack
           movea.l  d7,a1
           moveq    #ar.float,d4
           bra      lin2flt           float and return

*
* Search for the byte in D1 from A0 onwards for D3+1 bytes
*
scan_just1
           lea.l    scan_one,a4
           moveq    #0,d0

scan_one
           move.b   (a0)+,d0          get byte
           move.b   (a5,d0.w),d0
           cmp.b    d0,d1             Does it SEEM to match?
           dbeq     d3,scan_one
           bne.s    searched          D3 count exhausted, try another 64K?
           bra.s    found             A genuine match, return its position

*
searched   addq.w   #1,d3             Clear low word (previously -1)
           tst.l    d3                Is there more to be done?
           beq      bad_search        No - so the search was fruitless
           subq.l   #1,d3             Decrement high word & restore low word
           jmp      (a4)              Look through another 64K

*
           end
